% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain_analysis.R
\name{wbt_minimal_curvature}
\alias{wbt_minimal_curvature}
\title{Minimal curvature}
\usage{
wbt_minimal_curvature(
  dem,
  output,
  log = FALSE,
  zfactor = NULL,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{dem}{Input raster DEM file.}

\item{output}{Output raster file.}

\item{log}{Display output values using a log-scale.}

\item{zfactor}{Optional multiplier for when the vertical and horizontal units are not the same.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Calculates a mean curvature raster from an input DEM.
}
\keyword{GeomorphometricAnalysis}
