% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/math_stat_analysis.R
\name{wbt_conditional_evaluation}
\alias{wbt_conditional_evaluation}
\title{Conditional evaluation}
\usage{
wbt_conditional_evaluation(
  input,
  output,
  statement = "",
  true = NULL,
  false = NULL,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{input}{Name of the input raster file.}

\item{output}{Name of the output raster file.}

\item{statement}{Conditional statement e.g. value > 35.0. This statement must be a valid Rust statement.}

\item{true}{Value where condition evaluates TRUE (input raster or constant value).}

\item{false}{Value where condition evaluates FALSE (input raster or constant value).}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Performs a conditional evaluation (if-then-else) operation on a raster.
}
\keyword{MathandStatsTools}
