% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_analysis.R
\name{wbt_jenson_snap_pour_points}
\alias{wbt_jenson_snap_pour_points}
\title{Jenson snap pour points}
\usage{
wbt_jenson_snap_pour_points(
  pour_pts,
  streams,
  output,
  snap_dist,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{pour_pts}{Input vector pour points (outlet) file.}

\item{streams}{Input raster streams file.}

\item{output}{Output vector file.}

\item{snap_dist}{Maximum snap distance in map units.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Moves outlet points used to specify points of interest in a watershedding operation to the nearest stream cell.
}
\keyword{HydrologicalAnalysis}
