% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_analysis.R
\name{wbt_rho8_flow_accumulation}
\alias{wbt_rho8_flow_accumulation}
\title{Rho8 flow accumulation}
\usage{
wbt_rho8_flow_accumulation(
  input,
  output,
  out_type = "specific contributing area",
  log = FALSE,
  clip = FALSE,
  pntr = FALSE,
  esri_pntr = FALSE,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{input}{Input DEM or Rho8 pointer file; if a DEM is used, it must be depressionless.}

\item{output}{Name of the output raster file.}

\item{out_type}{Output type; one of 'cells', 'specific contributing area' (default), and 'catchment area'.}

\item{log}{Log-transform the output values?.}

\item{clip}{Optional flag to request clipping the display max by 1 percent.}

\item{pntr}{Is the input raster a Rho8 flow pointer rather than a DEM?.}

\item{esri_pntr}{Does the input Rho8 pointer use the ESRI style scheme?.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Calculates Fairfield and Leymarie (1991) flow accumulation.
}
\keyword{HydrologicalAnalysis}
