% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{ww_statsUSGS}
\alias{ww_statsUSGS}
\title{USGS stats}
\usage{
ww_statsUSGS(
  procDV,
  sites = NULL,
  temporalFilter = "daily",
  parameter_cd = NULL,
  days = 10,
  parallel = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{procDV}{A previously created \link[whitewater]{ww_dvUSGS} object.}

\item{sites}{A \code{character} USGS NWIS site.}

\item{temporalFilter}{A \code{character} for the stat summary window, e.g. 'daily' (default), 'monthly', 'yearly'.}

\item{parameter_cd}{A USGS code parameter code, only if using \code{sites} argument.}

\item{days}{A \code{numeric} input of days to go back from today (only needed if using .temporalFilter = 'daily').}

\item{parallel}{\code{logical} indicating whether to use future_map().}

\item{verbose}{\code{logical} for printing information. TRUE (default).}

\item{...}{arguments to pass on to \link[furrr]{future_map}.}
}
\value{
a tibble with associated site statistics.
}
\description{
This function uses the \link[dataRetrieval]{readNWISstat} to gather daily, monthly or yearly
percentiles.
}
\note{
Be aware, the parameter values ('Flow', 'Wtemp', etc) are calculated from the \link[whitewater]{ww_floorIVUSGS}
function by taking the daily mean of the hourly data. Thus, the instantaneous values will look different than the daily mean values, as it should.
The \code{.temporalFilter} argument is used to generate the window of percentiles.
}
\examples{
\dontrun{
# get by date range

yaak_river_dv <- ww_dvUSGS('12304500')

#daily
yaak_river_stats <- ww_statsUSGS(yaak_river_dv,
                                 temporalFilter = 'daily',
                                 days = 10)
#monthly
yaak_river_stats <- ww_statsUSGS(yaak_river_dv,
                                 temporalFilter = 'monthly',
                                 days = 10)
#yearly
yaak_river_stats <- ww_statsUSGS(yaak_river_dv,
                                 temporalFilter = 'yearly',
                                 days = 10)
}
}
