% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domain_info.R
\name{is_taken}
\alias{is_taken}
\title{Identify if a Domain is Taken}
\usage{
is_taken(token, domain, ...)
}
\arguments{
\item{token}{a token generated with \code{\link{whoapi_token}}}

\item{domain}{a domain name}

\item{...}{further arguments to pass to httr's GET.}
}
\value{
a boolean TRUE or FALSE indicating, respectively, whether the domain
is reserved/registered, or not.
}
\description{
\code{is_taken} identifies if a domain is taken - if
it's been reserve or registered.
}
\examples{
#Check if whoapi.com is taken
token <- whoapi_token("demokey")
\dontrun{
is_taken(token, "whoapi.com")
}
#[1] TRUE

}
\seealso{
\code{\link{whois_info}} for more information about a domain's status,
including when the registration expires and who has registered it.
}

