% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_dist.R
\name{pairwise_dist}
\alias{pairwise_dist}
\alias{pairwise_dist_}
\title{Distances of pairs of items}
\usage{
pairwise_dist(tbl, item, feature, value, method = "euclidean", ...)

pairwise_dist_(tbl, item, feature, value, method = "euclidean", ...)
}
\arguments{
\item{tbl}{Table}

\item{item}{Item to compare; will end up in \code{item1} and
\code{item2} columns}

\item{feature}{Column describing the feature that links one item to others}

\item{value}{Value}

\item{method}{Distance measure to be used; see \code{\link{dist}}}

\item{...}{Extra arguments passed on to \code{\link{squarely}},
such as \code{diag} and \code{upper}}
}
\description{
Compute distances of all pairs of items in a tidy table.
}
\examples{

library(gapminder)
library(dplyr)

# closest countries in terms of life expectancy over time
closest <- gapminder \%>\%
  pairwise_dist(country, year, lifeExp) \%>\%
  arrange(distance)

closest

closest \%>\%
  filter(item1 == "United States")

# to remove duplicates, use upper = FALSE
gapminder \%>\%
  pairwise_dist(country, year, lifeExp, upper = FALSE) \%>\%
  arrange(distance)

# Can also use Manhattan distance
gapminder \%>\%
  pairwise_dist(country, year, lifeExp, method = "manhattan", upper = FALSE) \%>\%
  arrange(distance)

}
\seealso{
\code{\link{squarely}}
}
