% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{w_SearchByLabel}
\alias{w_SearchByLabel}
\title{Search Wikidata entities}
\usage{
w_SearchByLabel(
  string,
  langsorder = "en",
  lang = "",
  instanceof = "",
  Pproperty = "",
  mode = c("exact", "startswith", "inlabel")
)
}
\arguments{
\item{string}{string (label or altLabel) to search.}

\item{langsorder}{Order of languages in which the information will be
returned, separated with '|'. If no information is given in the first
language, next is used. This parameter is mandatory, at least one language is
required, default, 'en'.}

\item{lang}{The language to search, only one. If lang="" and mode="inlabel",
search is in any language. Mandatory in mode="startswith", no effects in
mode="exact".}

\item{instanceof}{Wikidata entity of which the entities searched for are an
example or member of it (class). For example, if instanceof=Q5 the
search are filtered to Wikidata entities of class Q5 (human). Some
entity classes are allowed, separated with '|'.}

\item{Pproperty}{Wikidata properties, separated with '|', to optionally
include in the search. For example, is Pproperty="P21", the results
include information of the sex of entities found as STRING.}

\item{mode}{The mode to perform search: 'exact' for search using case
sensitive and differentiate diacritics; 'startswith' for entities which label
or altLabel starts with "string", similar to a wildcard search "string*",
searchs "string" in language "lang" in label, but in any language in
altLabel; 'inlabel' for matching whole words in any position. ('exact' by
default).}
}
\value{
A data-frame with 'entity', 'entityLabel', 'entityDescription',
(including 'instance', 'instanceLabel', 'altLabel' if mode="startswith")
and additionally the properties of Pproperty.
}
\description{
Search Wikidata entities in label and altLabel ("Also known as")
}
\examples{
df <- w_SearchByLabel(string='Iranzo', langsorder='es|en', mode="exact")
df <- w_SearchByLabel(string='Iranzo', langsorder='es|en', instanceof = 'Q5|Q101352', mode="exact")
## Search entities which label or altLabel starts with "string"
df <- w_SearchByLabel(string='Iranzo', lang='en', langsorder='es|en',
mode='startswith')
df <- w_SearchByLabel(string='Iranzo', lang='en', langsorder='en',
instanceof = 'Q5', Pproperty = 'P21|P569|P570', mode='startswith')
## Search in any position in Label or AltLabel (diacritics and case are ignored)
# If lang=='' search in any language, else the search is performed only in the
# language indicated.
df <- w_SearchByLabel(string='Iranzo', langsorder='es|en', mode='inlabel')
# Search in Chinese (Simplified) (language code: zh):
df <- w_SearchByLabel(string='Iranzo', langsorder='zh|es', lang='zh',
mode='inlabel')
}
\author{
Angel Zazo, Department of Computer Science and Automatics, University of Salamanca
}
