% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{w_LabelDesc}
\alias{w_LabelDesc}
\title{Return label and/or descriptions of Wikidata entities}
\usage{
w_LabelDesc(
  entity_list,
  what = "LD",
  langsorder = "en",
  nlimit = 25000,
  debug = FALSE
)
}
\arguments{
\item{entity_list}{A vector with de Wikidata entities.}

\item{what}{Retrieve only Labels (L), only Descriptions (D) or both (LD).}

\item{langsorder}{Order of languages in which the information will be
returned, separated with '|'. If no information is given in the first
language, next is used. This parameter is mandatory, at least one language is
required, default 'en'.}

\item{nlimit}{If the number of entities exceeds this number, chunked queries
are done. This is the number of entities requested in each chunk. Please,
reduce the default value if error is raised.}

\item{debug}{For debugging purposes (default FALSE). If debug='info'
information about chunked queries is shown. If debug='query' also the query
launched is shown.}
}
\value{
A data-frame with one column for the entities, and others for the
language and the labels and/or descriptions. The index of the dataframe is
also set to the entity list.
}
\description{
Return label and/or descriptions of the entities in entity_list in language
indicated in \code{langsorder}. Note that entities can be Wikidata entities (Qxxx)
or Wikidata properties (Pxxx).
}
\examples{
\dontrun{
w_LabelDesc(c("Q57860", "Q712609", "Q381800", "P569"), what='LD', langsorder = 'se|es|en')
}
}
\author{
Angel Zazo, Department of Computer Science and Automatics, University of Salamanca
}
