% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-query-type.R
\name{query_list_pages}
\alias{query_list_pages}
\alias{list_all_list_modules}
\title{List pages that meet certain criteria}
\usage{
query_list_pages(.req, list, ...)

list_all_list_modules()
}
\arguments{
\item{.req}{A httr2_request, e.g. generated by \code{wiki_action_request}}

\item{list}{The \href{https://www.mediawiki.org/wiki/API:Lists}{type of list} to return}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> Additional parameters to the query, e.g. to set configure list}
}
\value{
An HTTP response: an S3 list with class httr2_request
}
\description{
See \href{https://www.mediawiki.org/wiki/API:Lists}{API:Lists} for available
list actions. Each list action returns a list of pages, typically including
their pageid, \href{https://www.mediawiki.org/wiki/Manual:Namespace}{namespace}
and title. Individual lists have particular properties that can be requested,
which are usually prefaced with a two-word code based on the name of the
list (e.g. specific properties for the \code{categorymembers} list action are
prefixed with \code{cm}).
}
\details{
When the request is performed, the data is returned in the body of the
request under the \code{query} object, labeled by the chosen list action.

If you want to study the actual pages listed, it is advisable to retrieve
the pages directly using a generator, rather than listing their IDs using a
list action. When using a list action, a second request is required to get
further information about each page. Using a generator, you can query pages
and retrieve their relevant properties in a single API call.
}
\examples{
# Get the ten most recently added pages in Category:Physics
physics_pages <- wiki_action_request() \%>\%
  query_list_pages("categorymembers",
    cmsort = "timestamp",
    cmdir = "desc", cmtitle = "Category:Physics"
  ) \%>\%
  next_batch()

physics_pages
}
