% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path.R
\name{with_path}
\alias{with_path}
\alias{local_path}
\title{PATH environment variable}
\usage{
with_path(new, code, action = c("prefix", "suffix", "replace"))

local_path(
  new = list(),
  action = c("prefix", "suffix", "replace"),
  .local_envir = parent.frame()
)
}
\arguments{
\item{new}{\verb{[character]}\cr New \code{PATH} entries}

\item{code}{\code{[any]}\cr Code to execute in the temporary environment}

\item{action}{\verb{[character(1)]}\cr Should new values \code{"replace"}, \code{"prefix"}
(the default) or \code{"suffix"} existing paths}

\item{.local_envir}{\verb{[environment]}\cr The environment to use for scoping.}
}
\value{
\code{[any]}\cr The results of the evaluation of the \code{code}
argument.
}
\description{
Temporarily change the system search path.
}
\examples{
# temporarily modify the system PATH, *prefixing* the current path
with_path(getwd(), Sys.getenv("PATH"))
# temporarily modify the system PATH, *appending* to the current path
with_path(getwd(), Sys.getenv("PATH"), "suffix")
}
\seealso{
\code{\link{withr}} for examples

\code{\link[=Sys.setenv]{Sys.setenv()}}
}
