% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tempfile.R
\name{with_tempfile}
\alias{with_tempfile}
\alias{local_tempfile}
\alias{with_tempdir}
\alias{local_tempdir}
\title{Temporary files and directories}
\usage{
with_tempfile(
  new,
  code,
  envir = parent.frame(),
  .local_envir = parent.frame(),
  pattern = "file",
  tmpdir = tempdir(),
  fileext = ""
)

local_tempfile(
  new = NULL,
  lines = NULL,
  envir = parent.frame(),
  .local_envir = parent.frame(),
  pattern = "file",
  tmpdir = tempdir(),
  fileext = ""
)

with_tempdir(
  code,
  clean = TRUE,
  pattern = "file",
  tmpdir = tempdir(),
  fileext = ""
)

local_tempdir(
  pattern = "file",
  tmpdir = tempdir(),
  fileext = "",
  .local_envir = parent.frame(),
  clean = TRUE
)
}
\arguments{
\item{new}{\verb{[character vector]}\cr (Deprecated for \code{local_tempfile()}) Names of temporary file handles to create.}

\item{code}{\code{[any]}\cr Code to execute in the temporary environment}

\item{envir}{\verb{[environment]}\cr Deprecated in favor of \code{.local_envir}.}

\item{.local_envir}{\verb{[environment]}\cr The environment to use for scoping.}

\item{pattern}{a non-empty character vector giving the initial part
    of the name.}

\item{tmpdir}{a non-empty character vector giving the directory name}

\item{fileext}{a non-empty character vector giving the file extension}

\item{lines}{Optionally, supply a character vector of lines to be written to
\code{path}. This is useful if you want to seed the file with some default
content.}

\item{clean}{\verb{[logical(1)]}\cr A logical indicating if the temporary
directory should be deleted after use (\code{TRUE}, default) or left alone (\code{FALSE}).}
}
\value{
\code{[any]}\cr The results of the evaluation of the \code{code}
argument.
}
\description{
Temporarily create a file or directory, which will automatically deleted
once you're finished with it.
}
\examples{
# local_tempfile() is the easiest to use because it returns a path
local({
  path1 <<- local_tempfile(lines = c("x,y", "1,2"))
  readLines(path1)
})
# the file is deleted automatically
file.exists(path1)

# with_tempfile() is a bit trickier; the first argument gives the name
# of a variable that will contain the path:
with_tempfile("path2", {
  print(path2)
  write.csv(iris, path2)
  file.size(path2)
})

# Note that this variable is only available in the scope of with_tempfile
try(path2)
}
\seealso{
\code{\link{withr}} for examples
}
