% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grob.R
\name{wkt_grob}
\alias{wkt_grob}
\alias{wkb_grob}
\alias{wksxp_grob}
\title{Generate grid geometries from well-known geometries}
\usage{
wkt_grob(
  wkt,
  ...,
  rule = "evenodd",
  default.units = "native",
  name = NULL,
  vp = NULL
)

wkb_grob(
  wkt,
  ...,
  rule = "evenodd",
  default.units = "native",
  name = NULL,
  vp = NULL
)

wksxp_grob(
  wkt,
  ...,
  rule = "evenodd",
  default.units = "native",
  name = NULL,
  vp = NULL
)
}
\arguments{
\item{wkt}{A character vector containing well-known text.}

\item{...}{Graphical parameters passed to \code{\link[grid:gpar]{grid::gpar()}}. These are recycled along
the input. Dynamic dots (e.g., \verb{!!!}) are supported.}

\item{rule}{Use "winding" if polygon rings are correctly encoded with a winding
direction.}

\item{default.units}{Coordinate units, which may be defined by the viewport (see
\code{\link[grid:unit]{grid::unit()}}). Defaults to native.}

\item{name, vp}{Passed to \code{\link[grid:grid.points]{grid::pointsGrob()}}, \code{\link[grid:grid.lines]{grid::polylineGrob()}},
\code{\link[grid:grid.path]{grid::pathGrob()}}, or \code{\link[grid:grid.grob]{grid::gTree()}} depending on the types of geometries
in the input.}
}
\value{
A \link[grid:grid.grob]{graphical object}
}
\description{
Using \code{\link[=wkt_meta]{wkt_meta()}} and \code{\link[=wkt_coords]{wkt_coords()}}, these functions create graphical objects
using the grid package. Vectors that contain geometries of a single dimension
are efficiently packed into a \code{\link[grid:grid.points]{grid::pointsGrob()}}, \code{\link[grid:grid.lines]{grid::polylineGrob()}},
or \code{\link[grid:grid.path]{grid::pathGrob()}}. Vectors with mixed types and nested collections are encoded
less efficiently using a \code{\link[grid:grid.grob]{grid::gTree()}}.
}
\examples{
grid::grid.newpage()
grid::grid.draw(wkt_grob("POINT (0.5 0.5)", pch = 16, default.units = "npc"))

}
