% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licenses.R
\name{add_license_file}
\alias{add_license_file}
\title{Add License File to Project}
\usage{
add_license_file(path = ".", license = "ccby", ...)
}
\arguments{
\item{path}{Character, indicating the directory in which to create the
license file. Default: '.'.}

\item{license}{Character, indicating which license function to call.
The \code{usethis} functions all have the form \verb{use_\{licensename\}_license()}.
The \code{license} argument consists only of the \code{{licensename}}, e.g. \code{ccby}.}

\item{...}{Additional arguments passed to \code{usethis} function.}
}
\value{
No return value. This function is called for its side effects.
}
\description{
This function wraps \code{usethis}'
\code{\link[usethis:licenses]{licenses}} functions, which are
designed for R-packages. This function makes them applicable to other use
cases (e.g., WORCS projects, FAIR theory).
}
\examples{
if(requireNamespace("withr", quietly = TRUE)){
withr::with_tempdir({
add_license_file(path = ".",
                 license = "proprietary",
                 copyright_holder = "test")
})
}
}
