% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebook.R
\name{make_codebook}
\alias{make_codebook}
\title{Create codebook for a dataset}
\usage{
make_codebook(
  data,
  filename = "codebook.Rmd",
  render_file = TRUE,
  csv_file = gsub("Rmd$", "csv", filename),
  verbose = TRUE
)
}
\arguments{
\item{data}{A data.frame for which to create a codebook.}

\item{filename}{Character. File name to write the codebook \code{rmarkdown}
file to.}

\item{render_file}{Logical. Whether or not to render the document.}

\item{csv_file}{Character. File name to write the codebook \code{rmarkdown}
file to. By default, uses the filename stem of the \code{filename} argument.
Set to \code{NULL} to write the codebook only to the 'R Markdown' file, and
not to \code{.csv}.}

\item{verbose}{Logical. Whether or not to print status messages to
the console. Default: TRUE}
}
\value{
\code{Logical}, indicating whether or not the operation was
successful. This function is mostly called for its side effect of rendering
an 'R Markdown' codebook.
}
\description{
Creates a codebook for a dataset in 'R Markdown' format, and
renders it to 'markdown' for 'GitHub'. A codebook contains metadata and
documentation for a data file.
We urge users to customize the automatically generated 'R Markdown'
document and re-knit it, for example, to add a paragraph with details on
the data collection procedures. The variable descriptives are stored in
a \code{.csv} file, which can be edited in 'R' or a spreadsheet program.
Columns can be appended, and we encourage users to complete at least the
following two columns in this file:
\itemize{
\item{category} Describe the type of variable in this column. For example:
"morality".
\item{description} Provide a plain-text description of the variable. For
example, the full text of a questionnaire item: "People should be willing to
do anything to help a member of their family".
}
Re-knitting the 'R Markdown' file (using \code{\link[rmarkdown]{render}}) will
transfer these changes to the 'markdown' file for 'GitHub'.
}
\examples{
if(rmarkdown::pandoc_available("1.14")){
  library(rmarkdown)
  library(knitr)
  filename <- tempfile("codebook", fileext = ".Rmd")
  make_codebook(iris, filename = filename, csv_file = NULL)
  unlink(c(
    ".worcs",
    filename,
    gsub("\\\\.Rmd", "\\\\.md", filename),
    gsub("\\\\.Rmd", "\\\\.html", filename),
    gsub("\\\\.Rmd", "_files", filename)
  ), recursive = TRUE)
}
}
