% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export_project}
\alias{export_project}
\title{Export project to .zip file}
\usage{
export_project(zipfile = NULL, worcs_directory = ".", open_data = TRUE)
}
\arguments{
\item{zipfile}{Character. Path to a \code{.zip} file that is to be created.
The default argument \code{NULL} creates a \code{.zip} file in the directory
one level above the 'worcs' project directory. By default, all files tracked
by 'Git' are included in the \code{.zip} file, excluding 'data.csv' if
\code{open_data = FALSE}.}

\item{worcs_directory}{Character. Path to the WORCS project directory to
export. Defaults to \code{"."}, which refers to the current working
directory.}

\item{open_data}{Logical. Whether or not to include the original data,
'data.csv', if this file exists. If \code{open_data = FALSE} and an open
data file does exist, then it is excluded from the \code{.zip} file. If it
does not yet exist, a synthetic data set is generated and added to the
\code{.zip} file.}
}
\value{
Logical, indicating the success of the operation. This function is
called for its side effect of creating a \code{.zip} file.
}
\description{
Export project to .zip file
}
\examples{
export_project(worcs_directory = tempdir())
}
