% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantiles.R
\name{fit_vocab_quantiles}
\alias{fit_vocab_quantiles}
\title{Fit quantiles to vocabulary sizes using quantile regression}
\usage{
fit_vocab_quantiles(vocab_data, measure, group = NULL, quantiles = "standard")
}
\arguments{
\item{vocab_data}{A data frame returned by \code{get_administration_data}.}

\item{measure}{A column of \code{vocab_data} with vocabulary values
(\code{production} or \code{comprehension}).}

\item{group}{(Optional) A column of \code{vocab_data} to group by.}

\item{quantiles}{Either one of "standard" (default), "deciles", "quintiles",
"quartiles", "median", or a numeric vector of quantile values.}
}
\value{
A data frame with the columns "language", "form", "age", \code{group}
  (if specified), "quantile", and \code{measure}, where \code{measure} is the
  fit vocabulary value for that quantile at that age.
}
\description{
Fit quantiles to vocabulary sizes using quantile regression
}
\examples{
\dontrun{
eng_ws <- get_administration_data("English (American)", "WS")
fit_vocab_quantiles(eng_ws, production)
fit_vocab_quantiles(eng_ws, production, sex)
fit_vocab_quantiles(eng_ws, production, quantiles = "quartiles")
}
}
