% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wordbankr.R
\name{get_instrument_data}
\alias{get_instrument_data}
\title{Get the Wordbank administration-by-item data}
\usage{
get_instrument_data(
  language,
  form,
  items = NULL,
  administration_info = FALSE,
  item_info = FALSE,
  db_args = NULL,
  ...
)
}
\arguments{
\item{language}{A string of the instrument's language (insensitive to case
and whitespace).}

\item{form}{A string of the instrument's form (insensitive to case and
whitespace).}

\item{items}{A character vector of column names of \code{instrument_table} of
items to extract. If not supplied, defaults to all the columns of
\code{instrument_table}.}

\item{administration_info}{Either a logical indicating whether to include
administration data or a data frame of administration data (as returned by
\code{get_administration_data}).}

\item{item_info}{Either a logical indicating whether to include item data or
a data frame of item data (as returned by \code{get_item_data}).}

\item{db_args}{List with arguments to connect to wordbank mysql database
(host, dbname, user, and password).}

\item{...}{<[`dynamic-dots`][rlang::dyn-dots]> Arguments passed to
\code{get_administration_data()}.}
}
\value{
A data frame where each row contains the values (\code{value},
  \code{produces}, \code{understands}) of a given item (\code{item_id}) for a
  given administration (\code{data_id}), with additional columns of variables
  about the administration and item, as specified.
}
\description{
Get the Wordbank administration-by-item data
}
\examples{
\donttest{
eng_ws_data <- get_instrument_data(language = "English (American)",
                                   form = "WS",
                                   items = c("item_1", "item_42"),
                                   item_info = TRUE)
}
}
