% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env-manager.R
\name{EnvManager}
\alias{EnvManager}
\title{Allows managing the test environment}
\description{
This class provides a method for creating directories in the tempdir folder
for testing purposes. It also provides a method for reading files from the
inst/extdata folder.
}
\section{Super class}{
\code{\link[wordpredictor:Base]{wordpredictor::Base}} -> \code{EnvManager}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{EnvManager$new()}}
\item \href{#method-get_data_fn}{\code{EnvManager$get_data_fn()}}
\item \href{#method-remove_files}{\code{EnvManager$remove_files()}}
\item \href{#method-td_env}{\code{EnvManager$td_env()}}
\item \href{#method-cp_env}{\code{EnvManager$cp_env()}}
\item \href{#method-setup_env}{\code{EnvManager$setup_env()}}
\item \href{#method-clone}{\code{EnvManager$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
It initializes the current object. It simply calls the base class
constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EnvManager$new(rp = "../../", ve = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rp}}{The prefix for accessing the package root folder.}

\item{\code{ve}}{The level of detail in the information messages.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_data_fn"></a>}}
\if{latex}{\out{\hypertarget{method-get_data_fn}{}}}
\subsection{Method \code{get_data_fn()}}{
Checks if the given file exists. If it does not exist,
then it tries to load the file from the inst/extdata data folder of
the package. It throws an error if the file was not found. If the
file exists, then the method simply returns the file name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EnvManager$get_data_fn(fn, dfn)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fn}}{The file name.}

\item{\code{dfn}}{The name of the default file in the external data folder
of the package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The name of the file if it exists, or the full path to the
default file.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-remove_files"></a>}}
\if{latex}{\out{\hypertarget{method-remove_files}{}}}
\subsection{Method \code{remove_files()}}{
Removes all files in the given directory.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EnvManager$remove_files(dn)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dn}}{The directory name.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-td_env"></a>}}
\if{latex}{\out{\hypertarget{method-td_env}{}}}
\subsection{Method \code{td_env()}}{
Removes the ed folder created by the setup_env method. Also sets
the R option, "ed" to NULL.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EnvManager$td_env(rf = F)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rf}}{If the environment folder should be removed.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cp_env"></a>}}
\if{latex}{\out{\hypertarget{method-cp_env}{}}}
\subsection{Method \code{cp_env()}}{
Copies the ed folder created by the setup_env method to
inst/extdata.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EnvManager$cp_env()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setup_env"></a>}}
\if{latex}{\out{\hypertarget{method-setup_env}{}}}
\subsection{Method \code{setup_env()}}{
Copies the given files from test folder to the
environment folder.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EnvManager$setup_env(fns = c(), cf = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fns}}{The list of test files to copy}

\item{\code{cf}}{A custom environment folder. It is a path relative to the
current directory. If not specified, then the tempdir function is
used to generate the environment folder.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The list of folders that can be used during testing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EnvManager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
