% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_boots.R
\name{predict_boots}
\alias{predict_boots}
\title{Fit and predict from a workflow using many bootstrap resamples.}
\usage{
predict_boots(workflow, n = 100, training_data, new_data, ...)
}
\arguments{
\item{workflow}{An un-fitted workflow object.}

\item{n}{An integer for the number of bootstrap resampled models that will be created.}

\item{training_data}{A tibble or dataframe of data to be resampled and used for training.}

\item{new_data}{A tibble or dataframe used to make predictions.}

\item{...}{Additional params passed to \code{rsample::bootstraps()}.}
}
\value{
A tibble with a column indicating the row index of each observation in
\code{new_data} and a nested list of the model predictions for each observation.
}
\description{
Generate a prediction interval from arbitrary model types using bootstrap
resampling. \code{predict_boots()} generates \code{n} bootstrap resamples, fits a model
to each resample (creating \code{n} models), then creates \code{n} predictions for each
observation in \code{new_data}.
}
\details{
Since \code{predict_boots()} fits a new model to each resample, the
argument \code{workflow} must not yet be fit. Any tuned hyperparameters must be
finalized prior to calling \code{predict_boots()}.
}
\examples{
\dontrun{
library(tidymodels)

# setup a workflow without fitting
wf <-
  workflow() \%>\%
  add_recipe(recipe(qsec ~ wt, data = mtcars)) \%>\%
  add_model(linear_reg())

# fit and predict 125 bootstrap resampled models to mtcars
set.seed(123)
wf \%>\%
  predict_boots(n = 125, training_data = mtcars, new_data = mtcars)
}
}
