% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow_map.R
\name{workflow_map}
\alias{workflow_map}
\title{Process a series of workflows}
\usage{
workflow_map(
  object,
  fn = "tune_grid",
  verbose = FALSE,
  seed = sample.int(10^4, 1),
  ...
)
}
\arguments{
\item{object}{A workflow set.}

\item{fn}{The function to run. Acceptable values are: \code{\link[tune:tune_grid]{tune::tune_grid()}},
\code{\link[tune:tune_bayes]{tune::tune_bayes()}}, \code{\link[tune:fit_resamples]{tune::fit_resamples()}}, \code{finetune::tune_race_anova()},
\code{finetune::tune_race_win_loss()}, or \code{finetune::tune_sim_anneal()}.}

\item{verbose}{A logical for logging progress.}

\item{seed}{A single integer that is set prior to each function execution.}

\item{...}{Options to pass to the modeling function. See details below.}
}
\value{
An updated workflow set. The \code{option} column will be updated with
any options for the \code{tune} package functions given to \code{workflow_map()}. Also,
the results will be added to the \code{result} column. If the computations for a
workflow fail, an \code{try-catch} object will be saved in place of the results
(without stopping execution).
}
\description{
\code{workflow_map()} will execute the same function across the workflows in the
set. The various \verb{tune_*()} functions can be used as well as
\code{fit_resamples()}.
}
\details{
When passing options, anything passed in the \code{...} will be combined with any
values in the \code{option} column. The values in \code{...} will override that
column's values and the new options are added to the \code{options} column.

Any failures in execution result in the corresponding row of \code{results} to
contain a \code{try-error} object.

In cases where a model has no tuning parameters is mapped to one of the
tuning functions, \code{\link[tune:fit_resamples]{tune::fit_resamples()}} will be used instead and a
warning is issued if \code{verbose = TRUE}.
}
\examples{
# An example of processed results
chi_features_res

# Code examples at
if (interactive()) {
  system.file("example-data", package = "workflowsets")
}
}
\seealso{
\code{\link[=workflow_set]{workflow_set()}}, \code{\link[=as_workflow_set]{as_workflow_set()}}, \code{\link[=pull_workflow_set_result]{pull_workflow_set_result()}}
}
