% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\name{wb_region}
\alias{wb_region}
\title{World Bank region data}
\source{
\url{https://api.worldbank.org/v2/region}
}
\usage{
wb_region(region = NULL, lang = "en")
}
\arguments{
\item{region}{\code{character()} region to query. Default \code{NULL}.
If \code{NULL}, all regions are returned}

\item{lang}{\code{character(1)} language to query. Default \code{"en"}.}
}
\value{
A \code{data.frame()} with the available regions. The columns are:
\item{id}{The region ID.}
\item{code}{The region code.}
\item{iso2code}{The ISO 2 code of the region.}
\item{name}{The region name.}
}
\description{
List all regions supported by the World Bank API.
}
\examples{
wb_region()
}
\seealso{
Other indicators data: 
\code{\link{wb_country}()},
\code{\link{wb_income_level}()},
\code{\link{wb_indicator}()},
\code{\link{wb_language}()},
\code{\link{wb_lending_type}()},
\code{\link{wb_source}()},
\code{\link{wb_topic}()}
}
\concept{indicators data}
