% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMeta.R
\name{getMeta}
\alias{getMeta}
\title{Find a ISD site code and other meta data}
\usage{
getMeta(
  site = "heathrow",
  lat = NA,
  lon = NA,
  crs = 4326,
  country = NA,
  state = NA,
  n = 10,
  end.year = "current",
  provider = c("OpenStreetMap", "Esri.WorldImagery"),
  plot = TRUE,
  returnMap = FALSE
)
}
\arguments{
\item{site}{A site name search string e.g. \code{site = "heathrow"}. The search
strings and be partial and can be upper or lower case e.g. \code{site = "HEATHR"}.}

\item{lat, lon}{Decimal latitude and longitude (or other Y/X coordinate if
using a different \code{crs}). If provided, the \code{n} closest ISD stations to this
coordinate will be returned.}

\item{crs}{The coordinate reference system (CRS) of the data, passed to
\code{\link[sf:st_crs]{sf::st_crs()}}. By default this is \href{https://epsg.io/4326}{EPSG:4326}, the
CRS associated with the commonly used latitude and longitude coordinates.
Different coordinate systems can be specified using \code{crs} (e.g., \code{crs = 27700} for the \href{https://epsg.io/27700}{British National Grid}). Note that
non-lat/lng coordinate systems will be re-projected to EPSG:4326 for making
comparisons with the NOAA metadata plotting on the map.}

\item{country}{The country code. This is a two letter code. For a full
listing see \url{https://www1.ncdc.noaa.gov/pub/data/noaa/isd-history.csv}.}

\item{state}{The state code. This is a two letter code.}

\item{n}{The number of nearest sites to search based on \code{latitude} and
\code{longitude}.}

\item{end.year}{To help filter sites based on how recent the available data
are. \code{end.year} can be "current", "any" or a numeric year such as 2016, or
a range of years e.g. 1990:2016 (which would select any site that had an
end date in that range. \strong{By default only sites that have some data for the
current year are returned}.}

\item{provider}{By default a map will be created in which readers may toggle
between a vector base map and a satellite/aerial image. \code{provider} allows
users to override this default; see
\url{http://leaflet-extras.github.io/leaflet-providers/preview/} for a list
of all base maps that can be used. If multiple base maps are provided, they
can be toggled between using a "layer control" interface.}

\item{plot}{If \code{TRUE} will plot sites on an interactive leaflet map.}

\item{returnMap}{Should the leaflet map be returned instead of the meta data?
Default is \code{FALSE}.}
}
\value{
A data frame is returned with all available meta data, mostly
importantly including a \code{code} that can be supplied to \code{\link[=importNOAA]{importNOAA()}}. If
latitude and longitude searches are made an approximate distance, \code{dist} in
km is also returned.
}
\description{
Get information on meteorological sites
}
\details{
This function is primarily used to find a site code that can be used to
access data using \code{\link[=importNOAA]{importNOAA()}}. Sites searches of approximately 30,000
sites can be carried out based on the site name and based on the nearest
locations based on user-supplied latitude and longitude.
}
\examples{
\dontrun{
## search for sites with name beijing
getMeta(site = "beijing")
}

\dontrun{
## search for near a specified lat/lon - near Beijing airport
## returns 'n' nearest by default
getMeta(lat = 40, lon = 116.9)
}
}
\seealso{
Other NOAA ISD functions: 
\code{\link{getMetaLive}()},
\code{\link{importNOAA}()},
\code{\link{importNOAAlite}()}
}
\author{
David Carslaw
}
\concept{NOAA ISD functions}
