% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_IV.R
\name{calculate_IV}
\alias{calculate_IV}
\title{Calculate Weight of Evidence (WOE) and Information Value (IV) between a
single predictor and a single outcome variable.}
\usage{
calculate_IV(data, outcome, predictor, bins)
}
\arguments{
\item{data}{Data frame containing the data.}

\item{outcome}{String containing the name of the outcome variable.}

\item{predictor}{String containing the name of the predictor variable.}

\item{bins}{Numeric value representing the number of bins to use.}
}
\value{
A data frame is returned as an output.
}
\description{
Calculates Weight of Evidence (WOE) and Information Value (IV) between a
single predictor and a single outcome variable. This function implements the
common Information Value calculations whilst maintaining the minimum reliance
on external dependencies. Use \code{map_IV()} for the equivalent of
\code{Information::create_infotables()}, which performs calculations for multiple
predictors and a single outcome variable.
}
\details{
The approach used mirrors the one used in \code{Information::create_infotables()}.
}
