% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flex_index.R
\name{flex_index}
\alias{flex_index}
\title{Compute a Flexibility Index based on the Hourly Collaboration Query}
\usage{
flex_index(
  data,
  hrvar = NULL,
  signals = c("email", "IM"),
  active_threshold = 0,
  start_hour = "0900",
  end_hour = "1700",
  return = "plot",
  plot_method = "common",
  mode = "binary"
)
}
\arguments{
\item{data}{Hourly Collaboration query to be passed through as data frame.}

\item{hrvar}{A string specifying the HR attribute to cut the data by.
Defaults to NULL. This only affects the function when "table" is returned.}

\item{signals}{Character vector to specify which collaboration metrics to
use:
\itemize{
\item a combination of signals, such as \code{c("email", "IM")} (default)
\item \code{"email"} for emails only
\item \code{"IM"} for Teams messages only
\item \code{"unscheduled_calls"} for Unscheduled Calls only
\item \code{"meetings"} for Meetings only
}}

\item{active_threshold}{A numeric value specifying the minimum number of
signals to be greater than in order to qualify as \emph{active}. Defaults to 0.}

\item{start_hour}{A character vector specifying starting hours, e.g. \code{"0900"}}

\item{end_hour}{A character vector specifying end hours, e.g. \code{"1700"}}

\item{return}{String specifying what to return. This must be one of the
following strings:
\itemize{
\item \code{"plot"}
\item \code{"data"}
\item \code{"table"}
}

See \code{Value} for more information.}

\item{plot_method}{Character string for determining which plot to return.
\itemize{
\item \code{"sample"} plots a sample of ten working pattern
\item \code{"common"} plots the ten most common working patterns
\item \code{"time"} plots the Flexibility Index for the group over time
}}

\item{mode}{String specifying aggregation method for plot. Only applicable
when \code{return = "plot"}. Valid options include:
\itemize{
\item \code{"binary"}: convert hourly activity into binary blocks. In the plot, each
block would display as solid.
\item \code{"prop"}: calculate proportion of signals in each hour over total signals
across 24 hours, then average across all work weeks. In the plot, each
block would display as a heatmap.
}}
}
\value{
A different output is returned depending on the value passed to the \code{return}
argument:
\itemize{
\item \code{"plot"}: 'ggplot' object. A random of ten working patterns are displayed,
with diagnostic data and the Flexibility Index shown on the plot.
\item \code{"data"}: data frame. The original input data appended with the
Flexibility Index and the component scores. Can be used with
\code{plot_flex_index()} to recreate visuals found in \code{flex_index()}.
\item \code{"table"}: data frame. A summary table for the metric.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Pass an Hourly Collaboration query and compute a Flexibility Index for the
entire population. The Flexibility Index is a quantitative measure of the
freedom for employees to work at a time of their choice.
}
\details{
The \strong{Flexibility Index} is a metric that has been developed to quantify and
measure flexibility using behavioural data from Viva Insights. Flexibility
here refers to the freedom of employees to adopt a working arrangement of
their own choice, and more specifically refers to \strong{time} flexibility
(\emph{whenever} I want) as opposed to \strong{geographical} flexibility (\emph{wherever} I
want).

The \strong{Flexibility Index} is a score between 0 and 1, and is calculated based
on three component measures:
\itemize{
\item \code{ChangeHours}: this represents the freedom to define work start and end
time. Teams that embrace flexibility allow members to start and end their
workday at different times.
\item \code{TakeBreaks}: this represents the freedom define one's own schedule. In
teams that embrace flexibility, some members will choose to organize / split
their day in different ways (e.g. take a long lunch-break, disconnect in the
afternoon and reconnect in the evening, etc.).
\item \code{ControlHours}: this represents the freedom to switch off. Members who
choose alternative arrangements should be able to maintain a workload that is
broadly equivalent to those that follow standard arrangements.
}

The \strong{Flexibility Index} returns with one single score for each person-week,
plus the \strong{three} sub-component binary variables (\code{TakeBreaks},
\code{ChangeHours}, \code{ControlHours}). At the person-week level, each score can only
have the values 0, 0.33, 0.66, and 1. The Flexibility Index should only be
interpreted as a \strong{group} of person-weeks, e.g. the average Flexibility
Index of a team of 6 over time, where the possible values would range from 0
to 1.
}
\section{Context}{

The central feature of flexible working arrangements is
that it is the employee rather the employer who chooses the working
arrangement. \emph{Observed flexibility} serves as a proxy to assess whether a
flexible working arrangement are in place. The Flexibility Index is an
attempt to create such a proxy for quantifying and measuring flexibility,
using behavioural data from Viva Insights.
}

\section{Recurring disconnection time}{

The key component of \code{TakeBreaks} in the Flexibility Index is best
interpreted as 'recurring disconnection time'. This denotes an hourly block
where there is consistently no activity occurring throughout the week. Note
that this applies a stricter criterion compared to the common definition of
a break, which is simply a time interval where no active work is being
done, and thus the more specific terminology 'recurring disconnection time'
is preferred.
}

\section{Returning the raw data}{

The raw data containing the computed Flexibility Index can be returned with
the following:

\if{html}{\out{<div class="sourceCode">}}\preformatted{em_data \%>\%
  flex_index(return = "data")
}\if{html}{\out{</div>}}
}

\examples{
\donttest{
# Create a sample small dataset
orgs <- c("Customer Service", "Financial Planning", "Biz Dev")
em_data <- em_data[em_data$Organization \%in\% orgs, ]

# Examples of how to test the plotting options individually
# Sample of 10 work patterns
em_data \%>\%
  flex_index(return = "plot", plot_method = "sample")

# 10 most common work patterns
em_data \%>\%
  flex_index(return = "plot", plot_method = "common")

# Plot Flexibility Index over time
em_data \%>\%
  flex_index(return = "plot", plot_method = "time")

# Return a summary table with the computed Flexibility Index
em_data \%>\%
  flex_index(hrvar = "Organization", return = "table")
}

}
\seealso{
Other Working Patterns: 
\code{\link{identify_shifts_wp}()},
\code{\link{identify_shifts}()},
\code{\link{plot_flex_index}()},
\code{\link{workpatterns_area}()},
\code{\link{workpatterns_classify_bw}()},
\code{\link{workpatterns_classify_pav}()},
\code{\link{workpatterns_classify}()},
\code{\link{workpatterns_hclust}()},
\code{\link{workpatterns_rank}()},
\code{\link{workpatterns_report}()}
}
\concept{Working Patterns}
