% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPCAw.R
\name{plotPCAw}
\alias{plotPCAw}
\title{PCA plot with bag-plot to highlight groups}
\usage{
plotPCAw(
  dat,
  sampleGrp,
  tit = NULL,
  useSymb = c(21:25, 9:12, 3:4),
  center = TRUE,
  scale. = TRUE,
  colBase = NULL,
  useSymb2 = NULL,
  displBagPl = TRUE,
  getOutL = FALSE,
  cexTxt = 1,
  showLegend = TRUE,
  nGrpForMedian = 6,
  pointLabelPar = NULL,
  rowTyName = "genes",
  rotatePC = NULL,
  suplFig = TRUE,
  callFrom = NULL,
  silent = FALSE
)
}
\arguments{
\item{dat}{(matrix, data.frame, MArrayLM-object or list) data to plot. Note: \code{NA}-values cannot be processed - all lines with non-finite data (eg \code{NA}) will be omitted !
In case of  MArrayLM-object or list \code{dat} must conatain list-element named 'datImp','dat' or 'data'.}

\item{sampleGrp}{(character or factor) should be factor describing groups of replicates, NAs are not supported}

\item{tit}{(character) custom title}

\item{useSymb}{(integer) symbols to use (see also \code{\link[graphics]{par}})}

\item{center}{(logical or numeric) decide if variables should be shifted to be zero centered, argument passed to \code{\link[stats]{prcomp}}}

\item{scale.}{(logical or numeric) decide if scaling to obtain unit variance, argument passed to \code{\link[stats]{prcomp}}
Alternatively, a vector of length equal the number of columns of x can be supplied. The value is passed to scale.}

\item{colBase}{(character or integer) use custom colors}

\item{useSymb2}{(integer) symbol to mark group-center (no mark of group-center if default NULL) (equivalent to \code{pch}, see also \code{\link[graphics]{par}})}

\item{displBagPl}{(logical) if \code{TRUE}, show bagPlot (group-center) if >3 points per group otherwise the average-confidence-interval}

\item{getOutL}{(logical) return outlyer samples/values}

\item{cexTxt}{(integer) expansion factor for text (see also \code{\link[graphics]{par}})}

\item{showLegend}{(logical) toggle to display legend}

\item{nGrpForMedian}{(integer) decide if group center should be displayed via its average or median value: If group has less than 'nGrpForMedian' values, the average will be used, otherwise the median; if \code{NULL} no group centers will be displayed}

\item{pointLabelPar}{(character) define formatting for optional labels next to points in main figure (ie PC1 vs PC2); may be \code{TRUE} or list containing elments 'textLabel','textCol','textCex',
'textOffSet','textAdj' for fine-tuning}

\item{rowTyName}{(character) for subtitle : specify nature of rows (genes, proteins, probesets,...)}

\item{rotatePC}{(integer) optional rotation (by -1) for figure of the principal components specified by index}

\item{suplFig}{(logical) to include plots vs 3rd principal component (PC) and Screeplot}

\item{callFrom}{(character) allow easier tracking of message(s) produced}

\item{silent}{(logical) suppress messages}
}
\value{
plot and optional matrix of outlyer-data
}
\description{
Function to plot \href{https://en.wikipedia.org/wiki/Principal_component_analysis}{principal components analysis (PCA)}, 
with options to show center and potential outliers for each of the groups (columns of data).
One of the specificities of this implementation is the integration of bag-plots to better visualize different groups of points 
(if they can be organized so beforehand as distinct groups) :
The main body of data is shown as 'bag-plots' (a bivariate boxplot, see \href{https://en.wikipedia.org/wiki/Bagplot}{Bagplot})
with different transparent colors to highlight the core part of different groups (if they contain more than 2 values per group).
Furthermore, group centers are shown as average or median (see 'nGrpForMedian') with stars & index-number (if <25 groups).
Layout is automatically set to 2 or 4 subplots (if plotting more than 2 principal components makes sense).
Note : This function uses for calulating PCA \code{\link[stats]{prcomp}} with default \code{center=TRUE} and \code{scale.=FALSE}, (different to princomp() which standardizes by default).
Note: \code{NA}-values cannot (by definition) be processed by PCA - all lines with any non-finite values/content (eg \code{NA}) will be omitted !
Note : Package RColorBrewer may be used if avaialble.
Finally, note that several other packages dedicated to PCA exist, for example \href{https://CRAN.R-project.org/package=FactoMineR}{FactoMineR} offers 
 a very wide spectrum of possibiities, in particular for combined numeric and categorical data.
}
\examples{
set.seed(2019); dat1 <- matrix(round(c(rnorm(1000), runif(1000,-0.9,0.9)),2), 
  ncol=20, byrow=TRUE) + matrix(rep(rep(1:5,6:2), each=100), ncol=20)
biplot(prcomp(dat1))      # traditional plot
(grp = factor(rep(LETTERS[5:1],6:2)))
plotPCAw(dat1, grp)
}
\seealso{
(used in this function for the PCA underneith:) \code{\link[stats]{prcomp}}, \code{\link[stats]{princomp}}, the package \href{https://CRAN.R-project.org/package=FactoMineR}{FactoMineR}
}
