% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertPlotCoordPix.R
\name{.predPointsPix}
\alias{.predPointsPix}
\title{Predict and return pixel location of points of current plot}
\usage{
.predPointsPix(
  x,
  y,
  dimPng,
  res,
  marg,
  fromTop = TRUE,
  scExt = 0.04,
  displ = FALSE,
  callFrom = NULL,
  silent = FALSE,
  debug = FALSE
)
}
\arguments{
\item{x}{(numeric) initial coordinates for plot}

\item{y}{(numeric) initial coordinates for plot}

\item{dimPng}{(numeric, length=2) width and hight of png}

\item{res}{(numeric, length=1) resultion of png}

\item{marg}{(numeric, length=4) margins in inches (as given by \code{par(mar=c(...))})}

\item{fromTop}{(logical) default counting in html is from top}

\item{scExt}{(numeric, length=1) extending scale (default at 0.04 ie 4 \%)}

\item{displ}{(logical) optional plot}

\item{callFrom}{(character) allows easier tracking of messages produced}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additonal messages for debugging}
}
\value{
This function returns a numeric matrix with 2 columns 'xPix' and 'yPix' (with length(x) rows); and optionally a plot (if argument \code{displ=TRUE})
}
\description{
This function allows predicting the pixel location of points of current plot.
Note: may be imprecise in case of x or y with all same values.
}
\examples{
.predPointsPix(x=c(1,100), y=c(1,100), dimPng=c(700,600), res=200, marg=c(5,4,4,2))
}
\seealso{
\code{\link{convertPlotCoordPix}}, \code{\link{mouseOverHtmlFile}}
}
