% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/presenceFilt.R
\name{presenceFilt}
\alias{presenceFilt}
\title{Filter lines of matrix for max number of NAs}
\usage{
presenceFilt(dat, grp, maxGrpMiss = 1, ratMaxNA = 0.8, minVal = NULL,
  silent = FALSE, callFrom = NULL)
}
\arguments{
\item{dat}{matrix or data.frame}

\item{grp}{factor of min 2 levels describing which col of 'dat' belongs to which group (levels 1 & 2 will be used)}

\item{maxGrpMiss}{(numeric) at least 1 group has not more than this number of NAs (otherwise marke line as bad)}

\item{ratMaxNA}{(numeric)}

\item{minVal}{(default NULL or numeric), any value below will be treated like NA}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message produced}
}
\value{
logical matrix (with separate col for each pairwise combination of 'grp' levels) indicating if line of 'dat' acceptable based on NAs (and values minVal)
}
\description{
\code{presenceFilt} filters lines of 'dat' for sufficient presence/absence of NA values (ie limit number of NAs per line). 
Filter abundance/expression data for min number and/or ratio of values present/above threshold (incl NA) in at east 1 of multiple groups
difference proteomics/RNAseq : if peptide was identified its quantity is more certain than based on spectral alignment.
}
\examples{
dat1 <- matrix(1:56,ncol=7)
dat1[c(2,3,4,5,6,10,12,18,19,20,22,23,26,27,28,30,31,34,38,39,50,54)] <- NA
dat1; presenceFilt(dat1,gr=gl(3,3)[-(3:4)],maxGr=0)
presenceFilt(dat1,gr=gl(2,4)[-1],maxGr=1,ratM=0.1)
presenceFilt(dat1,gr=gl(2,4)[-1],maxGr=2,rat=0.5)
}
