% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineOverlapInfo.R
\name{combineOverlapInfo}
\alias{combineOverlapInfo}
\title{Find and combine points located very close in x/y space}
\usage{
combineOverlapInfo(
  dat,
  suplInfo = NULL,
  disThr = 0.01,
  addNsimil = TRUE,
  txtSepChar = ",",
  combSym = "+",
  maxOverl = 50,
  callFrom = NULL,
  debug = FALSE,
  silent = FALSE
)
}
\arguments{
\item{dat}{(matrix) matrix or data.frame with 2 cols (used ONLY 1st & 2nd column !), used as x & y coordinates}

\item{suplInfo}{(NULL or character) when points are considered overlapping the text from 'suplInfo' will be reduced to fragment before 'txtSepChar' and combined (with others from overlapping text) using 'combSym', if NULL $combInf will appear with row-numbers}

\item{disThr}{(numeric) distance-thrshold for considering as similar via searchDataPairs()}

\item{addNsimil}{(logical) include number of fused points}

\item{txtSepChar}{(character) for use with .retain1stPart(): where to cut (& keep 1st part) text from 'suplInfo' to return in out$CombInf; only 1st element used !}

\item{combSym}{(character) concatenation symbol (character, length=1) for points considered overlaying, see also 'suplInfo'}

\item{maxOverl}{(integer) if NULL no limit or max limit of group/clu size (avoid condensing too many neighbour points to single cloud)}

\item{callFrom}{(character) allow easier tracking of message(s) produced}

\item{debug}{(logical) additional messages for debugging}

\item{silent}{(logical) suppres messages}
}
\value{
matrix with fused (condensed) information for cluster of overapping points
}
\description{
Search points in x,y space that are located very close and thus likely to overlap.
In case of points close enough, various options for joining names (and shortening longer descriptions) are available.
}
\examples{
set.seed(2013)
datT2 <- matrix(round(rnorm(200)+3,1),ncol=2,dimnames=list(paste("li",1:100,sep=""),
  letters[23:24]))
# (mimick) some short and longer names for each line
inf2 <- cbind(sh=paste(rep(letters[1:4],each=26),rep(letters,4),1:(26*4),sep=""),
 lo=paste(rep(LETTERS[1:4],each=26),rep(LETTERS,4),1:(26*4),",",rep(letters[sample.int(26)],4),
  rep(letters[sample.int(26)],4),sep=""))[1:100,] 
head(datT2,n=10)
head(combineOverlapInfo(datT2,disThr=0.03),n=10)
head(combineOverlapInfo(datT2,suplI=inf2[,2],disThr=0.03),n=10)
}
