% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test2factLimma.R
\name{test2factLimma}
\alias{test2factLimma}
\title{2-factorial limma-style t-test}
\usage{
test2factLimma(
  datMatr,
  fac1,
  fac2,
  testSynerg = TRUE,
  testOrientation = "=",
  addResults = c("lfdr", "FDR", "Mval", "means"),
  addGenes = NULL,
  silent = FALSE,
  callFrom = NULL,
  debug = FALSE
)
}
\arguments{
\item{datMatr}{matrix or data.frame with lines as indenpendent series of measures (eg different genes)}

\item{fac1}{(character or factor) vector describing grouping elements of each line of 'datMatr' for first factor, must be of same langth as fac2}

\item{fac2}{(character or factor) vector describing grouping elements of each line of 'datMatr' for second factor, must be of same langth as fac1}

\item{testSynerg}{(logical) decide if factor-interactions (eg synergy) should be included to model}

\item{testOrientation}{(character) default (or any non-recignized input) '=', otherwise either '>','gerater','sup','upper' or '<','inf','lower'}

\item{addResults}{(character) vector defining which types of information should be included to output, may be 'lfdr','FDR' (for BY correction), 'Mval' (M values), 'means' (matrix with mean values for each group of replicates)}

\item{addGenes}{(matrix or data.frame) additional information to add to output}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of messages produced}

\item{debug}{(logical) additional messages for debugging}
}
\value{
This function returns an object of class "MArrayLM" (from limma) containing/enriched by the testing results
}
\description{
The aim of this function is to provide convenient acces to two-factorial (linear) testing withing the framework of \code{\link{makeMAList}} including the emprical Bayes shrinkage. 
The input data 'datMatr' which should already be organized as limma-type MAList, eg using using \code{\link{makeMAList}}. 
Note: This function uses the Bioconductor package \href{https://bioconductor.org/packages/release/bioc/html/limma.html}{limma}.
}
\examples{
set.seed(2014)
dat0 <- rnorm(30) + rep(c(10,15,19,20),c(9,8,7,6))
fa <- factor(rep(letters[1:4],c(9,8,7,6)))
dat2 <- data.frame(facA=rep(c("-","A","-","A"), c(9,8,7,6)),
  facB= rep(c("-","-","B","B"), c(9,8,7,6)), dat1=dat0, dat2=runif(30))
grpNa <- sub("-","",sub("\\\\.","", apply(dat2[,1:2], 1, paste, collapse="")))    
test2f <- test2factLimma(t(dat2[,3:4]), dat2$facA, dat2$facB, testS=FALSE)  
test2f 
# Now you can easily summarize results using topTable from limma
if(requireNamespace("limma", quietly=TRUE)) {
  library(limma)
  topTable(test2f, coef=1, n=5) 
  topTable(test2f, coef=2, n=5) } 
}
\seealso{
\code{\link{makeMAList}}, single line testing \code{\link[limma]{lmFit}} and the \code{eBayes}-family of functions in package \href{https://bioconductor.org/packages/release/bioc/html/limma.html}{limma}
}
