% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matr2list.R
\name{matr2list}
\alias{matr2list}
\title{Transform columns of matrix to list of vectors}
\usage{
matr2list(mat, concSym = ".", silent = FALSE, debug = TRUE, callFrom = NULL)
}
\arguments{
\item{mat}{(matrix) main input}

\item{concSym}{(character) symbol for concatenating: concatenation of named vectors in list names as colname(s)+'concSym'+rowname}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
matrix or array (1st dim is intraplate-position, 2nd .. plate-group/type, 3rd .. channels)
}
\description{
convert matrix to list of vectors: each column of 'mat' as vector of list
}
\examples{
mat1 <- matrix(1:12,ncol=3,dimnames=list(letters[1:4],LETTERS[1:3]))
mat2 <- matrix(LETTERS[11:22],ncol=3,dimnames=list(letters[1:4],LETTERS[1:3]))
matr2list(mat1);  matr2list(mat2)
}
\seealso{
\code{\link{convToNum}}
}
