% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ratioToPpm.R
\name{ratioToPpm}
\alias{ratioToPpm}
\title{Convert ratio to ppm}
\usage{
ratioToPpm(
  x,
  y = NULL,
  nSign = NULL,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{x}{(numeric) main input}

\item{y}{(numeric) optional value to construct ratios (x/y). If NULL (or different length as 'x'), then 'x' will be considered as ratio.}

\item{nSign}{(numeric) number of significan digits}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a numeric vector of ppm values
}
\description{
This function transforms ratio 'x' to ppm (parts per million). 
If 'y' not given (or different length as 'x'), then 'x' is assumed as ratio otherise rations are constructed as x/y is used lateron.
Does additional checking : negative values not expected - will be made absolute !
}
\examples{
set.seed(2017); aa <- c(1.000001,0.999999,1+rnorm(10,0,0.001))
cbind(x=aa,ppm=ratioToPpm(aa,nSign=4))
}
\seealso{
\code{\link{XYToDiffPpm}} for ppm of difference as used in mass spectrometrie
}
