% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correctWinPath.R
\name{correctWinPath}
\alias{correctWinPath}
\title{Correct mixed slash and backslash in file path}
\usage{
correctWinPath(
  x,
  asHtml = FALSE,
  anyPlatf = FALSE,
  silent = TRUE,
  callFrom = NULL
)
}
\arguments{
\item{x}{(character) input path to test and correct}

\item{asHtml}{(logical) option for use in html : add prefix "file:/"}

\item{anyPlatf}{(logical) if \code{TRUE}, checking will only be performed in Windows environement}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allows easier tracking of message(s) produced}
}
\value{
character vector with corrected path
}
\description{
This function corrects paths character strings for mixed slash and backslash in file path.
In Windows the function \code{tempdir()} will use double backslashes as separator while \code{file.path()} uses regular slashes.
So when combining these two one might encounter a mix of slashes and double backslashes which may cause trouble, unless this is streightened out to a single separator used.
When pointig to given files inside html-files, paths need to have a prefix, this can be added using the argument \code{asHtml}.
}
\examples{
path1 <- 'D:\\\\temp\\\\Rtmp6X8/working_dir\\\\RtmpKC/example.txt'
(path1b <- correctWinPath(path1, anyPlatf=TRUE)) 
(path1h <- correctWinPath(path1, anyPlatf=TRUE, asHtml=TRUE)) 
}
\seealso{
\code{\link[base]{tempfile}}, \code{\link[base]{file.path}}
}
