% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkSimValueInSer.R
\name{checkSimValueInSer}
\alias{checkSimValueInSer}
\title{Check for similar values in series}
\usage{
checkSimValueInSer(x, ppm = 5, sortX = TRUE)
}
\arguments{
\item{x}{numeric vector}

\item{ppm}{(numeric) ppm-range for considering as similar}

\item{sortX}{(logical) allows speeding up function when set to FALSE, for large data that are already sorted}
}
\value{
logical vector : FALSE for each entry of 'x' if value inside of ppm range to neighbour
}
\description{
\code{checkSimValueInSer} checks all values of 'x' for similar values outside/within (relative) range of 'ppm' (ie ambiguous within given range).
Return logical vector : FALSE for each entry of 'x' if value inside of ppm range to neighbour
}
\examples{
va1 <- c(4:7,7,7,7,7,8:10)+(1:11)/28600; checkSimValueInSer(va1)
cbind(va=va1,simil=checkSimValueInSer(va1))
}
\seealso{
similar with more options \code{\link{withinRefRange}}
}
