% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readUCSCgtf.R
\name{readUCSCgtf}
\alias{readUCSCgtf}
\title{Read gtf annotation files from UCSC}
\usage{
readUCSCgtf(
  gtfFiName,
  exportFileNa = "deUcsc2UniProt.dat",
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{gtfFiName}{(character) name (and path) of file to read}

\item{exportFileNa}{(character) optional file-name to be exported, if \code{NULL} no file will be written}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allows easier tracking of message(s) produced}
}
\value{
data.frame (with columns  $chr, $source, $type, $start, $end, $score, $strand, $frame, $features, $Ensrnot)
}
\description{
This function allos reading and importing genomic \href{https://genome.ucsc.edu/cgi-bin/hgTables}{gtf-annotation} data from UCSC.
In addition, a file with Ensrnot accessions only can be exported for further batch conversion on \href{https://www.uniprot.org/uploadlists/}{UniProt} by copy/pase to site,
since UCSC annotation data does not contain UniProt IDs. Subsequently, the resulting conversion by UniProt can be read and combined with UCSC annotation using \code{\link{readUniProtExport}}.
}
\examples{
path1 <- system.file("extdata",package="wrProteo")
gtfFi <- file.path(path1,"UCSC_hg38_chr11extr.gtf")
# here we'll write the file for UniProt conversion to tempdir to keep things tidy
expFi <- file.path(tempdir(),"deUcscForUniProt2.txt")
UcscAnnot1 <- readUCSCgtf(gtfFi,exportFileNa=expFi)
## results can be further combined with readUniProtExport() 
deUniProtFi <- file.path(path1,"deUniProt_hg38chr11extr.tab")
deUniPr1 <- readUniProtExport(deUniProtFi,deUcsc=UcscAnnot1,
  targRegion="chr11:1-135,086,622")  
deUniPr1[1:5,-5] 
}
\seealso{
\code{\link{readUniProtExport}}, \code{\link{readPDExport}}, \code{\link{readMaxQuantFile}},
}
