% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotROC.R
\name{plotROC}
\alias{plotROC}
\title{Plot ROC curves}
\usage{
plotROC(
  dat,
  ...,
  useCol = 2:3,
  methNames = NULL,
  col = NULL,
  pch = 1,
  bg = NULL,
  tit = NULL,
  point05 = 0.05,
  pointSi = 0.85,
  nByMeth = NULL,
  speciesOrder = NULL,
  txtLoc = c(0.4, 0.3, 0.04),
  legCex = 0.72,
  addSuplT = TRUE,
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{dat}{(matrix) from testing (eg  \code{\link{summarizeForROC}} )}

\item{...}{optional additional data-sets to include as seprate ROC-curves to same plot (must be of same type of format as 'dat')}

\item{useCol}{(integer or character, length=2) columns from \code{dat} to be used for pecificity and sensitivity}

\item{methNames}{(character) names of methods (data-sets) to be displayed}

\item{col}{(character) custom colors for lines and text (choose one color for each different data-set)}

\item{pch}{(integer) type of symbol to be used (see also \code{\link[graphics]{par}})}

\item{bg}{(character) background color in plot (see also \code{\link[graphics]{par}})}

\item{tit}{(character) custom title}

\item{point05}{(numeric) specific point to highlight in plot (typically at alpha=0.05)}

\item{pointSi}{(numeric) size of points (as expansion factor \code{cex})}

\item{nByMeth}{(integer) value of n to display}

\item{speciesOrder}{(integer) custom order of species in legend}

\item{txtLoc}{(numeric) location for text}

\item{legCex}{(numeric) cex expansion factor for legend (see also \code{\link[graphics]{par}})}

\item{addSuplT}{(logical) add text with information about precision,accuracy and FDR}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
plot only
}
\description{
\code{plotROC} plots ROC curves based on results from \code{\link{summarizeForROC}}. 
Does not return any data, plot only. Allows printing simultaneously multiple ROC curves from different studies. 
Was made for special consideration of 3 species mix as in proteomics benchmark
In the simplest case data were prepared using \code{\link[wrMisc]{moderTest2grp}}
}
\examples{
roc0 <- cbind(alph=c(2e-6,4e-5,4e-4,2.7e-3,1.6e-2,4.2e-2,8.3e-2,1.7e-1,2.7e-1,4.1e-1,5.3e-1,
	 6.8e-1,8.3e-1,9.7e-1), spec=c(1,1,1,1,0.957,0.915,0.915,0.809,0.702,0.489,0.362,0.234,
  0.128,0.0426), sens=c(0,0,0.145,0.942,2.54,2.68,3.33,3.99,4.71,5.87,6.67,8.04,8.77,
  9.93)/10, n.pos.a=c(0,0,0,0,2,4,4,9,14,24,36,41) )
plotROC(roc0)
}
\seealso{
\code{\link[wrProteo]{summarizeForROC}}, \code{\link[wrMisc]{moderTest2grp}}
}
