% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptives.R
\name{median_quart}
\alias{median_quart}
\title{Compute median and quartiles and put together.}
\usage{
median_quart(
  x,
  nround = NULL,
  probs = c(0.25, 0.5, 0.75),
  qtype = 8,
  roundDig = 2,
  drop0 = FALSE,
  groupvar = NULL,
  range = FALSE,
  rangesep = " ",
  rangearrow = " -> ",
  prettynum = FALSE,
  .german = FALSE,
  add_n = FALSE
)
}
\arguments{
\item{x}{Data for computation.}

\item{nround}{Number of digits for fixed round.}

\item{probs}{Quantiles to compute.}

\item{qtype}{Type of quantiles.}

\item{roundDig}{Number of relevant digits for roundR.}

\item{drop0}{Should trailing zeros be dropped?}

\item{groupvar}{Optional grouping variable for subgroups.}

\item{range}{Should min and max be included in output?}

\item{rangesep}{How should min/max be separated from mean+-sd?}

\item{rangearrow}{What is put between min -> max?}

\item{prettynum}{logical, apply prettyNum to results?}

\item{.german}{logical, should "." and "," be used as bigmark and decimal?}

\item{add_n}{Should n be included in output?}
}
\value{
character vector with median \code{[1stQuartile/3rdQuartile]}, rounded to desired precision
}
\description{
Compute median and quartiles and put together.
}
\examples{
# basic usage of median_quart
median_quart(x = mtcars$wt)
# with additional options
median_quart(x = mtcars$wt, groupvar = mtcars$am, add_n = TRUE)
}
