% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/let.R
\name{\%in_block\%}
\alias{\%in_block\%}
\title{Inline let-block notation.}
\usage{
a \%in_block\% b
}
\arguments{
\item{a}{(left argument) named character vector with target names as names, and replacement names as values.}

\item{b}{(right argument) expression or block to evaluate under let substitution rules.}
}
\value{
evaluated block.
}
\description{
Inline version of \code{let}-block.
}
\examples{

d <- data.frame(
  Sepal_Length=c(5.8,5.7),
  Sepal_Width=c(4.0,4.4),
  Species='setosa')

# let-block notation
let(
  qc(
    AREA_COL = Sepal_area,
    LENGTH_COL = Sepal_Length,
    WIDTH_COL = Sepal_Width
  ),
  d \%.>\%
    transform(., AREA_COL = LENGTH_COL * WIDTH_COL)
)

# \%in_block\% notation
qc(
  AREA_COL = Sepal_area,
  LENGTH_COL = Sepal_Length,
  WIDTH_COL = Sepal_Width
) \%in_block\% {
  d \%.>\%
    transform(., AREA_COL = LENGTH_COL * WIDTH_COL)
}

# Note: in packages can make assignment such as:
#   AREA_COL <- LENGTH_COL <- WIDTH_COL <- NULL
# prior to code so targets don't look like unbound names.

}
\seealso{
\code{\link{let}}
}
