% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf.R
\name{build_frame}
\alias{build_frame}
\title{Build a data.frame from the user's description.}
\usage{
build_frame(..., cf_eval_environment = parent.frame())
}
\arguments{
\item{...}{cell names, first infix operator denotes end of header row of column names.}

\item{cf_eval_environment}{environment to evaluate names in.}
}
\value{
character data.frame
}
\description{
A convenient way to build a data.frame in legible transposed form.  Position of
first "|" (or other infix operator) determines number of columns
(all other infix operators are aliases for ",").
Names are de-referenced.
}
\examples{

tc_name <- "training"
x <- build_frame(
   "measure",                   tc_name, "validation" |
   "minus binary cross entropy",      5, -7           |
   "accuracy",                      0.8, 0.6          )
print(x)
str(x)
cat(draw_frame(x))

build_frame(
  "x" |
  -1  |
  2   )

}
\seealso{
\code{\link{draw_frame}}, \code{\link{qchar_frame}}
}
