% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VectorizeM.R
\name{VectorizeM}
\alias{VectorizeM}
\title{Memoizing wrapper to base::Vectorize()}
\usage{
VectorizeM(
  FUN,
  vectorize.args = arg.names,
  SIMPLIFY = TRUE,
  USE.NAMES = TRUE,
  UNLIST = FALSE
)
}
\arguments{
\item{FUN}{function to apply}

\item{vectorize.args}{a character vector of arguments which should be vectorized. Defaults to first argument of FUN.  If set must be length 1.}

\item{SIMPLIFY}{logical or character string; attempt to reduce the result to a vector, matrix or higher dimensional array; see the simplify argument of sapply.}

\item{USE.NAMES}{logical; use names if the first ... argument has names, or if it is a character vector, use that character vector as the names.}

\item{UNLIST}{logical; if TRUE try to unlist the result.}
}
\value{
adapted function (vectorized with one call per different value).
}
\description{
Build a wrapped function that applies to each unique argument in a vector of arguments once.
}
\details{
Only sensible for pure side-effect free deterministic functions.
}
\examples{

fs <- function(x) { x <- x[[1]]; print(paste("see", x)); sin(x) }
fv <- VectorizeM(fs)
# should only print "see" twice, not 6 times
fv(c(0, 1, 1, 0, 0, 1))

}
\seealso{
\code{\link[base]{Vectorize}}, \code{\link{vapplym}}, \code{\link{lapplym}}
}
