% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syncexpl.R
\name{syncexpl}
\alias{syncexpl}
\alias{syncexpl.wlm}
\title{Amount of synchrony explained, and related quantities}
\usage{
syncexpl(object)

\method{syncexpl}{wlm}(object)
}
\arguments{
\item{object}{A \code{wlm} object}
}
\value{
\code{syncexpl} returns a data frame with columns for \code{timescales},
\code{sync} (the time-averaged square magnitude of the wavelet mean field of the
response transforms), \code{syncexpl} (synchrony explained by the model 
predictors), columns named for each predictor (synchrony explained by that 
predictor), \code{interactions} (synchrony explained by all interaction effects),
columns named for each pair of predictors (synchrony explained by individual
pairwise interactions). There are also columns for \code{crossterms} and 
\code{resids} (residuals). The cross terms must be small for a given timescale band for
the other results to be meaningful. All columns are functions of timescales.
}
\description{
Gives amount of synchrony explained by a wavelet linear model, as a function of 
timescale, and related quantities (see details)
}
\details{
This function only works for \code{norm="powall"} at present. See
Sheppard et al (2018) for details of the meaning and computation of the 
columns.
}
\examples{
times<-(-3:100)
ts1<-sin(2*pi*times/10)
ts2<-5*sin(2*pi*times/3)
artsig_x<-matrix(NA,11,length(times)) #the driver
for (counter in 1:11)
{
  artsig_x[counter,]=ts1+ts2+rnorm(length(times),mean=0,sd=1.5)
}
times<-0:100
artsig_y<-matrix(NA,11,length(times)) #the driven
for (counter1 in 1:11)
{
  for (counter2 in 1:101)
  {
    artsig_y[counter1,counter2]<-mean(artsig_x[counter1,counter2:(counter2+2)])
  }
}
artsig_y<-artsig_y+matrix(rnorm(length(times)*11,mean=0,sd=3),11,length(times))
artsig_x<-artsig_x[,4:104]
artsig_i<-matrix(rnorm(11*length(times)),11,length(times)) #the irrelevant
artsig_x<-cleandat(artsig_x,times,1)$cdat
artsig_y<-cleandat(artsig_y,times,1)$cdat
artsig_i<-cleandat(artsig_i,times,1)$cdat

dat<-list(driven=artsig_y,driver=artsig_x,irrelevant=artsig_i)
resp<-1
pred<-2:3
norm<-"powall"
wlmobj<-wlm(dat,times,resp,pred,norm)

res<-syncexpl(wlmobj)
 
}
\references{
Sheppard, LW et al. (2019) Synchrony is more than its top-down and climatic parts: interacting 
Moran effects on phytoplankton in British seas. Plos Computational Biology. In press.
}
\seealso{
\code{\link{wlm}}, \code{\link{predsync}}, \code{\link{wlmtest}},
\code{browseVignettes("wsyn")}
}
\author{
Thomas Anderson, \email{anderstl@gmail.com}, Jon Walter, \email{jaw3es@virginia.edu}; Lawrence 
Sheppard, \email{lwsheppard@ku.edu}; Daniel Reuman, \email{reuman@ku.edu}
}
