% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wpmf.R
\name{wpmf}
\alias{wpmf}
\title{Wavelet phasor mean field}
\usage{
wpmf(
  dat,
  times,
  scale.min = 2,
  scale.max.input = NULL,
  sigma = 1.05,
  f0 = 1,
  sigmethod = "none",
  nrand = 1000
)
}
\arguments{
\item{dat}{A locations (rows) x time (columns) matrix}

\item{times}{A vector of time step values, spacing 1}

\item{scale.min}{The smallest scale of fluctuation that will be examined. At least 2.}

\item{scale.max.input}{The largest scale of fluctuation guaranteed to be examined}

\item{sigma}{The ratio of each time scale examined relative to the next timescale. Should be greater than 1.}

\item{f0}{The ratio of the period of fluctuation to the width of the envelop}

\item{sigmethod}{Method for significance testing the wmpf, one of \code{quick}, \code{fft}, \code{aaft} (see details)}

\item{nrand}{The number of randomizations to be used for significance testing}
}
\value{
\code{wpmf} returns an object of class \code{wpmf}. Slots are:
\item{values}{A matrix of complex numbers containing the wavelet phasor mean field, of dimensions \code{length(times)} by the number of timescales. Entries not considered reliable (longer timescales, near the edges of the time span) are set to NA.}
\item{times}{The times associated with the data and the \code{wpmf}}
\item{timescales}{The timescales associated with the \code{wpmf}}
\item{signif}{A list with information from the significance testing. Format depends on \code{sigmethod} (see details).}
\item{dat}{The data matrix (locations by time) from which the \code{wpmf} was computed}
\item{wtopt}{The inputted wavelet transform options scale.min, scale.max.input, sigma, f0 in a list}
}
\description{
Computes the wavelet phasor mean field from a matrix of spatiotemporal data. Also the
creator function for the \code{wpmf} class. The \code{wpmf} class inherits from the 
\code{tts} class, which inherits from the \code{list} class.
}
\details{
For \code{sigmethod} equal to \code{quick}, the empirical wpmf is compared to a distribution of 
magnitudes of sums of random phasors, using the same number of phasors as there are time series. The \code{signif}
output is a list with first element "\code{quick}" and second element a vector of \code{nrand} magnitudes of sums 
of random phasors. For \code{sigmethod} equal to \code{fft}, the empirical wpmf is compared to wmpfs of 
Fourier surrogate datasets. The \code{signif} output is a list with first element "\code{fft}", second element 
equal to \code{nrand}, and third element the fraction of surrogate-based wpmf magnitudes that the empirical wpmf 
magnitude is greater than (times by timescales matrix). For \code{sigmethod} equal to \code{aaft}, \code{aaft} 
surrogates are used instead. Output has similar format to the \code{fft} case. Values other than \code{quick}, 
\code{fft}, and \code{aaft} for \code{sigmethod} result in no significance testing.
}
\examples{
times<-1:30 #generate time steps
#generate fake count data for 20 locations
dat<-matrix(rpois(20*length(times),20),nrow=20,ncol=length(times)) 
dat<-cleandat(dat=dat,times=times,clev=2)$cdat #detrend and demean
res<-wpmf(dat,times)

}
\references{
Sheppard, L.W., et al. (2016) Changes in large-scale climate alter spatial synchrony of aphid 
pests. Nature Climate Change. DOI: 10.1038/nclimate2881
}
\seealso{
\code{\link{wpmf_methods}}, \code{\link{wmf}}, \code{\link{tts}}, \code{\link{plotmag}}, 
\code{browseVignettes("wsyn")}
}
\author{
Thomas Anderson, \email{anderstl@gmail.com}, Jon Walter, \email{jaw3es@virginia.edu}; Lawrence 
Sheppard, \email{lwsheppard@ku.edu}; Daniel Reuman, \email{reuman@ku.edu}
}
