% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odds.ratio.R
\name{odds.ratio}
\alias{odds.ratio}
\title{Odds ratio}
\usage{
odds.ratio(data, y, w.order, which.pair)
}
\arguments{
\item{data}{a data frame or matrix contains genotypes in the columns. Genotypes should be coded as (0, 1, 2) or (0, 1).}

\item{y}{a numeric vector.}

\item{w.order}{a numeric number taking values 1 or 2. If w.order = 1, main effect is calculated. If w.order = 2, pairwise interaction effect is calculated.}

\item{which.pair}{a numeric vector with length = w.order indicates which pair to calculate the odds ratio.}
}
\value{
The odds ratio of one marker
}
\description{
Function to calculate odds ratio of both main effect and pair wise interaction. Odds ratio of pair wise interaction is calculated by the coefficient of the interaction term in Logistic Regression.
}
\examples{
data(mydata)
data(phenotype1)
y<-as.numeric(phenotype1)
result <- odds.ratio(mydata,y,w.order=2,which.pair=c(4,8))
}
