#' Meteorological training data for weather generator from nine stations
#'
#' * Weather data (precipitation, temperature) from nine stations within the Global Historical Climatology Network (GHCN):
#'  + USC00162534	(DONALDSONVILLE 4 SW LA, US)
#'  + USC00050372	(ASPEN 1 SW CO, US)
#'  + USC00080236	(ARCHBOLD BIO STATION FL, US)
#'  + USC00440766	(BLACKSBURG NWS VA, US)
#'  + USW00014606	(BANGOR INTL. AIRPORT ME, US)
#'  + USW00094240	(QUILLAYUTE AIRPORT WA, US)
#'  + USC00346386	(NORMAN 3 SSE OK, US)
#'  + USC00028795	(TUCSON 17 NW AZ, US)
#'  + USC00472314	(EAGLE RIVER WI, US)
#'
#' @docType data
#'
#' @usage data(stationData)
#'
#' @format A data frame.
#'
#' @keywords data
#'
#' @source \href{https://www.ncei.noaa.gov/products/land-based-station/global-historical-climatology-network-daily}{Global Historical Climatology Network}
#'
#' @examples
#' data(stationData)
"stationData"
