\name{summary-methods}
\docType{methods}
\alias{summary-methods}
\alias{summary,x12Output-method}
\alias{summary,x12Single-method}
\alias{summary,x12Batch-method}
\alias{summary}

\title{ ~~ Methods for Function \code{summary} in Package \pkg{x12} ~~}
\description{
Delivers a diagnostics summary for \code{\link{x12}} output.
}
\section{Methods}{
\describe{

%\item{\code{signature(x = "ANY")}}{
%%  ~~describe this method here~~
%}

\item{\code{signature(x = "x12Output")}}{
%%  ~~describe this method here~~
}

\item{\code{signature(x = "x12Single")}}{
%%  ~~describe this method here~~
}

\item{\code{signature(x = "x12Batch")}}{
%%  ~~describe this method here~~
}
}}

\usage{
\S4method{summary}{x12Output}(object, fullSummary=FALSE, spectra.detail=FALSE,
  almostout=FALSE, rsd.autocorr=NULL,
  quality.stat=FALSE, likelihood.stat=FALSE, aape=FALSE, id.rsdseas=FALSE,
  slidingspans=FALSE,
  history=FALSE, identify=FALSE, print=TRUE)
\S4method{summary}{x12Single}(object, fullSummary=FALSE, spectra.detail=FALSE,
  almostout=FALSE, rsd.autocorr=NULL,
  quality.stat=FALSE, likelihood.stat=FALSE, aape=FALSE, id.rsdseas=FALSE,
  slidingspans=FALSE,
  history=FALSE, identify=FALSE, oldOutput=NULL,print=TRUE)                      
\S4method{summary}{x12Batch}(object, fullSummary=FALSE, spectra.detail=FALSE,
  almostout=FALSE, rsd.autocorr=NULL,
  quality.stat=FALSE, likelihood.stat=FALSE, aape=FALSE, id.rsdseas=FALSE,
  slidingspans=FALSE,
  history=FALSE, identify=FALSE, oldOutput=NULL,print=TRUE)                      
}

\arguments{
 \item{object}{object of class \code{\link{x12Output-class}}, \code{\link{x12Single-class}} or \code{\link{x12Batch-class}}.}
  \item{fullSummary}{logical defining whether all available optional diagnostics below should be included in the summary.}
  \item{spectra.detail}{logical defining whether more detail on the spectra should be returned.}
  \item{almostout}{logical defining whether "almost" outliers should be returned.}
  \item{rsd.autocorr}{character or character vector specifying the type of autocorrelation of
  the residuals that should be returned, i.e. the autocorrelations and/or partial autocorrelations 
  of the residuals and/or the autocorrelations of the squared residuals (\code{"acf"}, \code{"pacf"}, \code{"acf2"}).}
  \item{quality.stat}{logical defining whether the second Q statistic, i.e. the Q Statistic computed w/o the M2 Quality Control Statistic,
  and the M statistics for monitoring and quality assessment should be returned as well.}
  \item{likelihood.stat}{if \code{TRUE}, the likelihood statistics AIC, AICC, BIC and HQ are returned as well
  as the estimated maximum value of the log likelihood function of the model for the untransformed data.}
  \item{aape}{logical defining whether the average absolute percentage error for forecasts should be returned.}
  \item{id.rsdseas}{logical defining whether the presence/absence of residual seasonality should be indicated.}
  \item{slidingspans}{logical defining whether the diagnostics output of the slidingspans analysis should be returned.}
  \item{history}{logical defining whether the diagnostics output of the (revision) history analysis should be returned.}
  \item{identify}{logical defining whether the (partial) autocorrelations of the residuals generated by the "identify" specification should be returned.}
  \item{oldOutput}{integer specifying the number of previous \code{x12} runs stored in the \code{x12OldOutput} slot of
  an \code{x12Single-class} or an \code{x12Batch-class} object that should be included in the summary.}
  \item{print}{TRUE/FALSE if the summary should be printed.}
}

\author{Alexander Kowarik, Angelika Meraner}

\seealso{\code{\link{prev}},
	\code{\link{cleanHistory}}
}

\examples{

\dontrun{
# Summary of an "x12Single" object
x12path("../x12a.exe")
s <- new("x12Single",ts=AirPassengers,tsName="air")
s <- setP(s,list(estimate=TRUE,regression.variables="AO1950.1",outlier.types="all",
  outlier.critical=list(LS=3.5,TC=2.5),backcast_years=1/2))
s <- x12(s)
summary.output<-summary(s)
s <- x12(setP(s,list(arima.model=c(0,1,1),arima.smodel=c(0,2,1))))
summary.output<-summary(s,oldOutput=1)
s <- x12(setP(s,list(arima.model=c(0,1,1),arima.smodel=c(1,0,1))))
summary.output<-summary(s,fullSummary=TRUE,oldOutput=2)

# Summary of an "x12Batch" object
xb <- new("x12Batch",list(AirPassengers,AirPassengers,
				AirPassengers),tsName=c("air1","air2","air3"))
xb <- x12(xb)
xb <- setP(xb,list(arima.model=c(1,1,0),arima.smodel=c(1,1,0)),1)
xb <- x12(xb)
xb <- setP(xb,list(regression.variables=c("AO1955.5","AO1956.1","ao1959.3")),1)
xb <- setP(xb,list(regression.variables=c("AO1955.4")),2)
xb<- x12(xb)
xb <- setP(xb,list(outlier.types="all"))
xb <- setP(xb,list(outlier.critical=list(LS=3.5,TC=2.5)),1)
xb <- setP(xb,list(regression.variables=c("lpyear")),3)
xb<- x12(xb)
summary.output<-summary(xb,oldOutput=3)
}
}
