% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask_x3p.R
\name{x3p_add_mask}
\alias{x3p_add_mask}
\title{Add/Exchange a mask for an x3p object}
\usage{
x3p_add_mask(x3p, mask = NULL)
}
\arguments{
\item{x3p}{x3p object}

\item{mask}{raster matrix of colors with the same dimensions as the x3p surface. If NULL, an object of the right size will be created.}
}
\value{
x3p object with added/changed mask
}
\description{
Create a mask for an x3p object in case it does not have a mask yet.
Masks are used for overlaying colors on the bullets surface.
}
\examples{
x3p <- read_x3p(system.file("sample-land.x3p", package="x3ptools"))
# x3p file has mask consisting color raster image:
x3p$mask[1:5,1:5]
\dontrun{
logo <- read_x3p(system.file("csafe-logo.x3p", package="x3ptools"))
color_logo <- png::readPNG(system.file("csafe-color.png", package="x3ptools"))
logoplus <- x3p_add_mask(logo, as.raster(color_logo))
image_x3p(logoplus, multiply=50, size = c(741, 419),zoom = 0.5)
}
}
