% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x3p_crop.R
\name{x3p_crop}
\alias{x3p_crop}
\title{Crop an x3p object to a specified width and height}
\usage{
x3p_crop(x3p, x = 1, y = 1, width = 128, height = 128)
}
\arguments{
\item{x3p}{x3p object}

\item{x}{integer, location (in pixels) of the leftmost side of the rectangle,}

\item{y}{integer, location (in pixels) of the leftmost side of the rectangle,}

\item{width}{integer, width (in pixels) of the rectangle,}

\item{height}{integer, height (in pixels) of the rectangle,}
}
\description{
Cuts out a rectangle of size width x height from the location (x, y) of an x3p object.
x and y specify the bottom right corner of the rectangle.
In case the dimensions of the surface matrix do not allow for the full dimensions of the rectangle cutout the dimensions are adjusted accordingly.
}
\examples{
logo <- x3p_read(system.file("csafe-logo.x3p", package="x3ptools"))
# crop the x3p file to just the CSAFE logo
logo_only <- x3p_crop(logo, x=20, y=50, width = 255 ,height =310)
logo_only <- x3p_crop(logo, x=20, y=50, width = 255 ,height =510)
# x3p_image(logo_only, size=c(500,500), zoom = 1)
}
