% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x3p_select.R
\name{x3p_extract_profile}
\alias{x3p_extract_profile}
\title{Interactively select a line on the active rgl device}
\usage{
x3p_extract_profile(x3p, col = "#FF0000", update = TRUE, line_out = TRUE)
}
\arguments{
\item{x3p}{x3p file}

\item{col}{character value of the selection color}

\item{update}{boolean value, whether the rgl window should be updated to show the selected circle}

\item{line_out}{boolean enhavce result by a data frame of the line? Note that variable x indicates the direction from first click (x=0) to
the second click (max x). The values of x in the result are in the same units as the original x3p.}
}
\value{
x3p file with identified in mask enhanced by a dataframe of the line segment (line_df).
}
\description{
In the active rgl device select a line on the 3d surface by clicking on start and end-point (order matters). These points define the beginning and end  of a line segment.
The line segment is drawn on the mask of the x3p object. The returned x3p object is expanded by a data frame of surface measurements along the line segment.
}
\examples{
\dontrun{
if (interactive) {
  x3p <- x3p_read(system.file("sample-land.x3p", package="x3ptools"))
  x3p \%>\% image_x3p(size=dim(x3p$surface.matrix), multiply=1, zoom=.3)
  x3p <- x3p_extract_profile(x3p, update=TRUE, col="#FFFFFF") 
  x3p$line_df \%>\% 
    ggplot(aes(x = x, y = value)) + geom_line() 
 
 x3p$line_df$y <- 1      
 sigs <- bulletxtrctr::cc_get_signature(ccdata = x3p$line_df, 
   grooves = list(groove=c(min(x3p$line_df$x), max(x3p$line_df$x))), span1 = 0.75, span2 = 0.03)
 sigs \%>\% 
   ggplot(aes(x = x)) + 
     geom_line(aes(y = raw_sig), colour = "grey50") +
     geom_line(aes(y = sig), size = 1) +
     theme_bw() 
}}
}
