% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterizeROI.R
\name{rasterizeROI}
\alias{rasterizeROI}
\title{Rasterize ROI Polygons}
\usage{
rasterizeROI(pnts, imgSize)
}
\arguments{
\item{pnts}{a two column matrix of points as relative x and y values (0 to 1)}

\item{imgSize}{size of the final raster}
}
\description{
This function convert point-based polygons to raster format
}
\examples{

pnts <- matrix(c(0.1, 0.2,
                 0.1, 0.4,
                 0.5, 0.4,
                 0.5, 0.2),
                 4, 2, byrow= TRUE)
imgSize <- c(300, 400)
m <- rasterizeROI(pnts, imgSize)
xROI::addMask(m, add = FALSE)

}
\keyword{Polygons}
\keyword{ROI}
\keyword{Rasterize}
