% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_duo.R
\name{style_duo}
\alias{style_duo}
\title{Duotone Theme}
\usage{
style_duo(
  primary_color = "#1F4257",
  secondary_color = "#F97B64",
  text_color = choose_dark_or_light(primary_color, darken_color(primary_color, 0.9),
    lighten_color(secondary_color, 0.99)),
  header_color = secondary_color,
  background_color = primary_color,
  link_color = secondary_color,
  text_bold_color = secondary_color,
  text_slide_number_color = text_color,
  padding = "16px 64px 16px 64px",
  background_image = NULL,
  background_size = NULL,
  background_position = NULL,
  code_highlight_color = "rgba(255,255,0,0.5)",
  code_inline_color = secondary_color,
  code_inline_background_color = NULL,
  code_inline_font_size = "1em",
  inverse_background_color = secondary_color,
  inverse_text_color = primary_color,
  inverse_text_shadow = FALSE,
  inverse_header_color = primary_color,
  inverse_link_color = link_color,
  title_slide_text_color = secondary_color,
  title_slide_background_color = primary_color,
  title_slide_background_image = NULL,
  title_slide_background_size = NULL,
  title_slide_background_position = NULL,
  footnote_color = NULL,
  footnote_font_size = "0.9em",
  footnote_position_bottom = "60px",
  left_column_subtle_color = apply_alpha(secondary_color, 0.6),
  left_column_selected_color = secondary_color,
  blockquote_left_border_color = apply_alpha(secondary_color, 0.5),
  table_border_color = "#666",
  table_row_border_color = "#ddd",
  table_row_even_background_color = lighten_color(primary_color, 0.9),
  base_font_size = "20px",
  text_font_size = "1rem",
  header_h1_font_size = "2.75rem",
  header_h2_font_size = "2.25rem",
  header_h3_font_size = "1.75rem",
  header_background_auto = FALSE,
  header_background_color = header_color,
  header_background_text_color = background_color,
  header_background_padding = NULL,
  header_background_content_padding_top = "7rem",
  header_background_ignore_classes = c("normal", "inverse", "title", "middle",
    "bottom"),
  text_slide_number_font_size = "0.9rem",
  text_font_google = NULL,
  text_font_family = xaringanthemer_font_default("text_font_family"),
  text_font_weight = xaringanthemer_font_default("text_font_weight"),
  text_bold_font_weight = "bold",
  text_font_url = xaringanthemer_font_default("text_font_url"),
  text_font_family_fallback = xaringanthemer_font_default("text_font_family_fallback"),
  text_font_base = "sans-serif",
  header_font_google = NULL,
  header_font_family = xaringanthemer_font_default("header_font_family"),
  header_font_weight = xaringanthemer_font_default("header_font_weight"),
  header_font_family_fallback = "Georgia, serif",
  header_font_url = xaringanthemer_font_default("header_font_url"),
  code_font_google = NULL,
  code_font_family = xaringanthemer_font_default("code_font_family"),
  code_font_size = "0.9rem",
  code_font_url = xaringanthemer_font_default("code_font_url"),
  code_font_family_fallback = xaringanthemer_font_default("code_font_family_fallback"),
  link_decoration = "none",
  colors = NULL,
  extra_css = NULL,
  extra_fonts = NULL,
  outfile = "xaringan-themer.css"
)
}
\arguments{
\item{primary_color}{Duotone Primary Color. Defaults to #1F4257. Used in
multiple CSS rules. The value of this variable is also stored as a CSS
variable that can be referenced with \code{var(--primary)} in any argument of a
style function or in custom CSS.}

\item{secondary_color}{Duotone Secondary Color. Defaults to #F97B64. Used in
multiple CSS rules. The value of this variable is also stored as a CSS
variable that can be referenced with \code{var(--secondary)} in any argument of
a style function or in custom CSS.}

\item{text_color}{Text Color. Defaults to
\code{choose_dark_or_light(primary_color, darken_color(primary_color, 0.9), lighten_color(secondary_color, 0.99))}.
Modifies the \code{body} element. The value of this variable is also stored as
a CSS variable that can be referenced with \code{var(--text_color)} in any
argument of a style function or in custom CSS.}

\item{header_color}{Header Color. Defaults to \code{secondary_color}. Modifies
the \verb{h1, h2, h3} elements. The value of this variable is also stored as a
CSS variable that can be referenced with \code{var(--header-color)} in any
argument of a style function or in custom CSS.}

\item{background_color}{Slide Background Color. Defaults to \code{primary_color}.
Modifies the \code{.remark-slide-content} class. The value of this variable is
also stored as a CSS variable that can be referenced with
\code{var(--background-color)} in any argument of a style function or in custom
CSS.}

\item{link_color}{Link Color. Defaults to \code{secondary_color}. Modifies the
\verb{a, a > code} elements. The value of this variable is also stored as a CSS
variable that can be referenced with \code{var(--link-color)} in any argument
of a style function or in custom CSS.}

\item{text_bold_color}{Bold Text Color. Defaults to \code{secondary_color}.
Modifies the \code{strong} element. The value of this variable is also stored
as a CSS variable that can be referenced with \code{var(--text-bold-color)} in
any argument of a style function or in custom CSS.}

\item{text_slide_number_color}{Slide Number Color. Defaults to \code{text_color}.
Modifies the \code{.remark-slide-number} class.}

\item{padding}{Slide Padding in \verb{top right [bottom left]} format. Defaults
to 16px 64px 16px 64px. Modifies the \code{.remark-slide-content} class.
Accepts CSS
\href{https://developer.mozilla.org/en-US/docs/Web/CSS/padding}{padding}
property values.}

\item{background_image}{Background image applied to each \emph{and every} slide.
Set \code{title_slide_background_image = "none"} to remove the background image
from the title slide. Defaults to \code{NULL}. Modifies the
\code{.remark-slide-content} class.}

\item{background_size}{Background image size, requires \code{background_image} to
be set. If \code{background_image} is set, \code{background_size} will default to
\code{cover} so the background fills the screen. If both \code{background_image} and
\code{background_position} are set, will default to 100 percent. Defaults to
\code{NULL}. Modifies the \code{.remark-slide-content} class. Accepts CSS
\href{https://developer.mozilla.org/en-US/docs/Web/CSS/background-size}{background-size}
property values.}

\item{background_position}{Background image position, requires
\code{background_image} to be set, and it is recommended to adjust
\code{background_size}. Defaults to \code{NULL}. Modifies the
\code{.remark-slide-content} class. Accepts CSS
\href{https://developer.mozilla.org/en-US/docs/Web/CSS/background-position}{background-position}
property values.}

\item{code_highlight_color}{Code Line Highlight. Defaults to
rgba(255,255,0,0.5). Modifies the \code{.remark-code-line-highlighted} class.
The value of this variable is also stored as a CSS variable that can be
referenced with \code{var(--code-highlight-color)} in any argument of a style
function or in custom CSS.}

\item{code_inline_color}{Inline Code Color. Defaults to \code{secondary_color}.
Modifies the \code{.remark-inline-code} class.}

\item{code_inline_background_color}{Inline Code Background Color. Defaults
to \code{NULL}. Modifies the \code{.remark-inline-code} class.}

\item{code_inline_font_size}{Inline Code Text Font Size. Defaults to 1em.
Modifies the \code{.remark-inline-code} class. Accepts CSS
\href{https://developer.mozilla.org/en-US/docs/Web/CSS/font-size}{font-size}
property values. The value of this variable is also stored as a CSS
variable that can be referenced with \code{var(--code-inline-font-size)} in any
argument of a style function or in custom CSS.}

\item{inverse_background_color}{Inverse Background Color. Defaults to
\code{secondary_color}. Modifies the \code{.inverse} class. The value of this
variable is also stored as a CSS variable that can be referenced with
\code{var(--inverse-background-color)} in any argument of a style function or
in custom CSS.}

\item{inverse_text_color}{Inverse Text Color. Defaults to \code{primary_color}.
Modifies the \code{.inverse} class. The value of this variable is also stored
as a CSS variable that can be referenced with \code{var(--inverse-text-color)}
in any argument of a style function or in custom CSS.}

\item{inverse_text_shadow}{Enables Shadow on text of inverse slides.
Defaults to \code{FALSE}. Modifies the \code{.inverse} class.}

\item{inverse_header_color}{Inverse Header Color. Defaults to
\code{primary_color}. Modifies the \verb{.inverse h1, .inverse h2, .inverse h3}
classes. The value of this variable is also stored as a CSS variable that
can be referenced with \code{var(--inverse-header-color)} in any argument of a
style function or in custom CSS.}

\item{inverse_link_color}{Inverse Link Color. Defaults to \code{link_color}.
Modifies the \verb{.inverse a, .inverse a > code} classes. The value of this
variable is also stored as a CSS variable that can be referenced with
\code{var(--inverse-link-color)} in any argument of a style function or in
custom CSS.}

\item{title_slide_text_color}{Title Slide Text Color. Defaults to
\code{secondary_color}. Modifies the \code{.title-slide} class. The value of this
variable is also stored as a CSS variable that can be referenced with
\code{var(--title-slide-text-color)} in any argument of a style function or in
custom CSS.}

\item{title_slide_background_color}{Title Slide Background Color. Defaults
to \code{primary_color}. Modifies the \code{.title-slide} class. The value of this
variable is also stored as a CSS variable that can be referenced with
\code{var(--title-slide-background-color)} in any argument of a style function
or in custom CSS.}

\item{title_slide_background_image}{Title Slide Background Image URL.
Defaults to \code{NULL}. Modifies the \code{.title-slide} class.}

\item{title_slide_background_size}{Title Slide Background Image Size,
defaults to "cover" if background image is set. Defaults to \code{NULL}.
Modifies the \code{.title-slide} class. Accepts CSS
\href{https://developer.mozilla.org/en-US/docs/Web/CSS/background-size}{background-size}
property values.}

\item{title_slide_background_position}{Title Slide Background Image
Position. Defaults to \code{NULL}. Modifies the \code{.title-slide} class. Accepts
CSS
\href{https://developer.mozilla.org/en-US/docs/Web/CSS/background-position}{background-position}
property values.}

\item{footnote_color}{Footnote text color (if \code{NA}, then it will be the same
color as \code{text_color}). Defaults to \code{NULL}. Modifies the \code{.footnote}
class.}

\item{footnote_font_size}{Footnote font size. Defaults to 0.9em. Modifies
the \code{.footnote} class. Accepts CSS
\href{https://developer.mozilla.org/en-US/docs/Web/CSS/font-size}{font-size}
property values.}

\item{footnote_position_bottom}{Footnote location from bottom of screen.
Defaults to 60px. Modifies the \code{.footnote} class. Accepts CSS
\href{https://developer.mozilla.org/en-US/docs/Web/CSS/position_value}{position}
property values.}

\item{left_column_subtle_color}{Left Column Text (not last). Defaults to
\code{apply_alpha(secondary_color, 0.6)}. Modifies the
\verb{.left-column h2, .left-column h3} classes.}

\item{left_column_selected_color}{Left Column Current Selection. Defaults to
\code{secondary_color}. Modifies the
\verb{.left-column h2:last-of-type, .left-column h3:last-child} classes.}

\item{blockquote_left_border_color}{Blockquote Left Border Color. Defaults
to \code{apply_alpha(secondary_color, 0.5)}. Modifies the \code{blockquote} element.}

\item{table_border_color}{Table top/bottom border. Defaults to #666.
Modifies the \verb{table: border-top, border-bottom} elements.}

\item{table_row_border_color}{Table row inner bottom border. Defaults to
#ddd. Modifies the \verb{table thead th: border-bottom} elements.}

\item{table_row_even_background_color}{Table Even Row Background Color.
Defaults to \code{lighten_color(primary_color, 0.9)}. Modifies the
\verb{thead, tfoot, tr:nth-child(even)} elements.}

\item{base_font_size}{Base Font Size for All Slide Elements (must be \code{px}).
Defaults to 20px. Modifies the \code{html} element. The value of this variable
is also stored as a CSS variable that can be referenced with
\code{var(--base-font-size)} in any argument of a style function or in custom
CSS.}

\item{text_font_size}{Slide Body Text Font Size. Defaults to 1rem. Modifies
the \code{.remark-slide-content} class. Accepts CSS
\href{https://developer.mozilla.org/en-US/docs/Web/CSS/font-size}{font-size}
property values. The value of this variable is also stored as a CSS
variable that can be referenced with \code{var(--text-font-size)} in any
argument of a style function or in custom CSS.}

\item{header_h1_font_size}{h1 Header Text Font Size. Defaults to 2.75rem.
Modifies the \verb{.remark-slide-content h1} class. Accepts CSS
\href{https://developer.mozilla.org/en-US/docs/Web/CSS/font-size}{font-size}
property values. The value of this variable is also stored as a CSS
variable that can be referenced with \code{var(--header-h1-font-size)} in any
argument of a style function or in custom CSS.}

\item{header_h2_font_size}{h2 Header Text Font Size. Defaults to 2.25rem.
Modifies the \verb{.remark-slide-content h2} class. Accepts CSS
\href{https://developer.mozilla.org/en-US/docs/Web/CSS/font-size}{font-size}
property values. The value of this variable is also stored as a CSS
variable that can be referenced with \code{var(--header-h2-font-size)} in any
argument of a style function or in custom CSS.}

\item{header_h3_font_size}{h3 Header Text Font Size. Defaults to 1.75rem.
Modifies the \verb{.remark-slide-content h3} class. Accepts CSS
\href{https://developer.mozilla.org/en-US/docs/Web/CSS/font-size}{font-size}
property values. The value of this variable is also stored as a CSS
variable that can be referenced with \code{var(--header-h3-font-size)} in any
argument of a style function or in custom CSS.}

\item{header_background_auto}{Add background under slide title automatically
for h1 header elements. If not enabled, use \code{class: header_background} to
enable. Defaults to \code{FALSE}.}

\item{header_background_color}{Background Color for h1 Header with
Background. Defaults to \code{header_color}. Modifies the
\verb{.remark-slide-content h1} class. The value of this variable is also
stored as a CSS variable that can be referenced with
\code{var(--header-background-color)} in any argument of a style function or in
custom CSS.}

\item{header_background_text_color}{Text Color for h1 Header with
Background. Defaults to \code{background_color}. Modifies the
\verb{.remark-slide-content h1} class. The value of this variable is also
stored as a CSS variable that can be referenced with
\code{var(--header-background-text-color)} in any argument of a style function
or in custom CSS.}

\item{header_background_padding}{Padding for h1 Header with Background.
Defaults to \code{NULL}. Modifies the \verb{.remark-slide-content h1} class. Accepts
CSS \href{https://developer.mozilla.org/en-US/docs/Web/CSS/padding}{padding}
property values.}

\item{header_background_content_padding_top}{Top Padding for Content in
Slide with Header with Background. Defaults to 7rem. Modifies the
\code{.remark-slide-content} class.}

\item{header_background_ignore_classes}{Slide Classes Where Header with
Background will not be Applied. Defaults to
\code{c('normal', 'inverse', 'title', 'middle', 'bottom')}. Modifies the
\code{.remark-slide-content} class.}

\item{text_slide_number_font_size}{Slide Number Text Font Size. Defaults to
0.9rem. Modifies the \code{.remark-slide-number} class. Accepts CSS
\href{https://developer.mozilla.org/en-US/docs/Web/CSS/font-size}{font-size}
property values.}

\item{text_font_google}{Use \code{google_font()} to specify body font. Defaults
to \code{NULL}. Modifies the \code{body} element.}

\item{text_font_family}{Body Text Font Family (xaringan default is
\code{'Droid Serif'}). Defaults to
\code{xaringanthemer_font_default("text_font_family")}. Modifies the \code{body}
element. The value of this variable is also stored as a CSS variable that
can be referenced with \code{var(--text-font-family)} in any argument of a
style function or in custom CSS.}

\item{text_font_weight}{Body Text Font Weight. Defaults to
\code{xaringanthemer_font_default("text_font_weight")}. Modifies the \code{body}
element. Accepts CSS
\href{https://developer.mozilla.org/en-US/docs/Web/CSS/font-weight}{font-weight}
property values.}

\item{text_bold_font_weight}{Body Bold Text Font Weight. Defaults to bold.
Modifies the \code{strong} element.}

\item{text_font_url}{Body Text Font URL(s). Defaults to
\code{xaringanthemer_font_default("text_font_url")}. Modifies the
\verb{@import url()} elements.}

\item{text_font_family_fallback}{Body Text Font Fallbacks. Defaults to
\code{xaringanthemer_font_default("text_font_family_fallback")}. Modifies the
\code{body} element. The value of this variable is also stored as a CSS
variable that can be referenced with \code{var(--text-font-family-fallback)} in
any argument of a style function or in custom CSS.}

\item{text_font_base}{Body Text Base Font (Total Failure Fallback). Defaults
to sans-serif. Modifies the \code{body} element. The value of this variable is
also stored as a CSS variable that can be referenced with
\code{var(--text-font-base)} in any argument of a style function or in custom
CSS.}

\item{header_font_google}{Use \code{google_font()} to specify header font.
Defaults to \code{NULL}. Modifies the \code{body} element.}

\item{header_font_family}{Header Font Family (xaringan default is
\code{'Yanone Kaffeesatz'}). Defaults to
\code{xaringanthemer_font_default("header_font_family")}. Modifies the
\verb{h1, h2, h3} elements. The value of this variable is also stored as a CSS
variable that can be referenced with \code{var(--header-font-family)} in any
argument of a style function or in custom CSS.}

\item{header_font_weight}{Header Font Weight. Defaults to
\code{xaringanthemer_font_default("header_font_weight")}. Modifies the
\verb{h1, h2, h3} elements. Accepts CSS
\href{https://developer.mozilla.org/en-US/docs/Web/CSS/font-weight}{font-weight}
property values.}

\item{header_font_family_fallback}{Header Font Family Fallback. Defaults to
Georgia, serif. Modifies the \verb{h1, h2, h3} elements. The value of this
variable is also stored as a CSS variable that can be referenced with
\code{var(--header-font-family-fallback)} in any argument of a style function
or in custom CSS.}

\item{header_font_url}{Header Font URL. Defaults to
\code{xaringanthemer_font_default("header_font_url")}. Modifies the
\verb{@import url} elements.}

\item{code_font_google}{Use \code{google_font()} to specify code font. Defaults
to \code{NULL}. Modifies the \code{body} element.}

\item{code_font_family}{Code Font Family. Defaults to
\code{xaringanthemer_font_default("code_font_family")}. Modifies the
\verb{.remark-code, .remark-inline-code} classes. The value of this variable is
also stored as a CSS variable that can be referenced with
\code{var(--code-font-family)} in any argument of a style function or in custom
CSS.}

\item{code_font_size}{Code Text Font Size. Defaults to 0.9rem. Modifies the
\code{.remark-inline} class. Accepts CSS
\href{https://developer.mozilla.org/en-US/docs/Web/CSS/font-size}{font-size}
property values. The value of this variable is also stored as a CSS
variable that can be referenced with \code{var(--code-font-size)} in any
argument of a style function or in custom CSS.}

\item{code_font_url}{Code Font URL. Defaults to
\code{xaringanthemer_font_default("code_font_url")}. Modifies the \verb{@import url}
elements.}

\item{code_font_family_fallback}{Code Font Fallback. Defaults to
\code{xaringanthemer_font_default("code_font_family_fallback")}. Modifies the
\verb{.remark-code, .remark-inline-code} classes.}

\item{link_decoration}{Text decoration of links. Defaults to none. Modifies
the \verb{a, a > code} elements. Accepts CSS
\href{https://developer.mozilla.org/en-US/docs/Web/CSS/text-decoration}{text-decoration}
property values.}

\item{colors}{A named vector of custom colors. The names of the colors
become CSS variables and classes that can be used within your slides.
For example, \code{colors = c(blue = "#bad4ed")} adds a CSS variable
\code{--blue}, a \code{.blue} CSS class that applies the color to the text or
foreground color, and a \code{.bg-blue} CSS class that applies the color
to the background.}

\item{extra_css}{A named list of CSS definitions each containing a named list
of CSS property-value pairs, i.e.
\code{list(".class-id" = list("css-property" = "value"))}.}

\item{extra_fonts}{A list of additional fonts to import, each list element
can be either a URL as a character string or a call to
\code{\link{google_font}()}. To use a font imported in \code{extra_fonts}, you
will need to write custom CSS rules that apply the font to an element or
class with the \code{font-family} property. See the \strong{Fonts} section of
\code{vignette("xaringanthemer")} for an example.}

\item{outfile}{Customized xaringan CSS output file name, default is "xaringan-themer.css"}
}
\value{
The CSS styles are written to the file path provided in \code{outfile}
(by default to \code{xaringan-themer.css}). If \code{outfile} is \code{NULL}, the CSS is
returned directly as a character string.
}
\description{
A duotone theme designed to work well with two complementary
colors.
}
\section{Usage}{
 To use the styles created by this theme function, make sure
that you use \code{xaringan-themer.css} as your CSS file in your slides' YAML
header. If you change the name of the output file using the \code{outfile}
argument, use that name instead of the default file name.\if{html}{\out{<div class="yaml">}}\preformatted{output:
xaringan::moon_reader:
  css: xaringan-themer.css
}\if{html}{\out{</div>}}
}

\examples{
# Create a xaringan style in a temporary file
xaringan_themer_css <- tempfile("xaringan-themer-", fileext = ".css")

style_duo(
  primary_color = "#1f4257",
  secondary_color = "#f97b64",
  outfile = xaringan_themer_css # omit in your slides to write the
                                # styles to xaringan-themer.css
)

# View the CSS:
# file.edit(xaringan_themer_css)
}
\seealso{
Other themes: 
\code{\link{style_duo_accent_inverse}()},
\code{\link{style_duo_accent}()},
\code{\link{style_mono_accent_inverse}()},
\code{\link{style_mono_accent}()},
\code{\link{style_mono_dark}()},
\code{\link{style_mono_light}()},
\code{\link{style_solarized_dark}()},
\code{\link{style_solarized_light}()},
\code{\link{xaringanthemer_font_default}()}

Other Duotone themes: 
\code{\link{style_duo_accent_inverse}()},
\code{\link{style_duo_accent}()}
}
\concept{Duotone themes}
\concept{themes}
